% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/boxplot.R
\docType{methods}
\name{boxplot}
\alias{boxplot}
\alias{boxplot,LogRatio-method}
\alias{boxplot,GroupedLogRatio-method}
\title{Boxplot of Log-Ratios}
\usage{
\S4method{boxplot}{LogRatio}(
  x,
  ...,
  range = 1.5,
  width = NULL,
  varwidth = FALSE,
  notch = FALSE,
  outline = TRUE,
  plot = TRUE,
  horizontal = FALSE,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann")
)

\S4method{boxplot}{GroupedLogRatio}(
  x,
  ...,
  range = 1.5,
  width = NULL,
  varwidth = FALSE,
  notch = FALSE,
  outline = TRUE,
  plot = TRUE,
  horizontal = FALSE,
  color = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  legend = list(x = "topright")
)
}
\arguments{
\item{x}{A \code{\linkS4class{LogRatio}} object.}

\item{...}{Further graphical parameters.}

\item{range}{A length-one \code{\link{numeric}} vector specifying how far the plot
whiskers extend out from the box (see \code{\link[graphics:boxplot]{graphics::boxplot()}}).}

\item{width}{A \code{\link{numeric}} vector giving the relative widths of the boxes
making up the plot.}

\item{varwidth}{A \code{\link{logical}} scalar: should the boxes be drawn with widths
proportional to the square-roots of the number of observations in the
groups?}

\item{notch}{A \code{\link{logical}} scalar: should a notch be drawn in each side of
the boxes?}

\item{outline}{A \code{\link{logical}} scalar: should the outliers be drawn?}

\item{plot}{A \code{\link{logical}} scalar: should a boxplot be produced? If \code{FALSE},
the summaries which the boxplots are based on are invisibly returned.}

\item{horizontal}{A \code{\link{logical}} scalar: should the boxplots be horizontal?}

\item{xlab, ylab}{A \code{\link{character}} vector giving the x and y axis labels.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y axis labels) appear on the plot?}

\item{color}{A (named) vector of colors (will be mapped to the group names
of \code{object}) or a \code{\link{function}} that when called with a single argument (an
integer specifying the number of colors) returns a vector of colors.}

\item{legend}{A \code{\link{list}} of additional arguments to be passed to
\code{\link[graphics:legend]{graphics::legend()}}; names of the list are used as argument names.
If \code{NULL}, no legend is displayed.}
}
\value{
\code{boxplot()} is called for its side-effects: is results in a graphic being
displayed (invisibly return \code{x}).
}
\description{
Displays box-and-whisker plots of the given (grouped) values.
}
\examples{
## Data from Day et al. 2011
data("kommos", package = "folio")
kommos <- remove_NA(kommos, margin = 1) # Remove cases with missing values
coda <- as_composition(kommos, parts = 3:22) # Coerce to compositional data

## Log ratio
clr <- transform_clr(coda)

## Boxplot
boxplot(clr)

## Use ceramic types for grouping
grp <- group(coda, by = kommos$type)
clr <- transform_clr(grp)
boxplot(clr)
}
\seealso{
\code{\link[graphics:boxplot]{graphics::boxplot()}}

Other plot methods: 
\code{\link{as_graph}()},
\code{\link{barplot}()},
\code{\link{hist}()},
\code{\link{pairs}()},
\code{\link{plot}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
