% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztdraw_cumulative_intensity.R
\name{ztdraw_cumulative_intensity}
\alias{ztdraw_cumulative_intensity}
\title{Simulate from a zero-truncated non homogeneous Poisson Point Process (zt-NHPPP) from
(t_min, t_max) (order statistics method)}
\usage{
ztdraw_cumulative_intensity(Lambda, Lambda_inv, t_min, t_max, atmost1 = FALSE)
}
\arguments{
\item{Lambda}{(function, double vector) a continuous increasing R to R map
which is the integrated rate of the NHPPP}

\item{Lambda_inv}{(function, double vector) the inverse of \code{Lambda()}}

\item{t_min}{(double) the lower bound of the time interval}

\item{t_max}{(double) the upper bound of the time interval}

\item{atmost1}{(boolean) draw at most 1 event time}
}
\value{
a vector of at least 1 event times
}
\description{
Sample zero-truncated NHPPP times using the order statistics method,
optionally using an \code{rstream} generator
}
