% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_data.R
\name{sim_data}
\alias{sim_data}
\title{Simulate data.}
\usage{
sim_data(
  n,
  fit = list(Pri = list(c(0, 0, 0, 0.5, 0.25, 0.25, 0, 0)), Tran = list(matrix(c(0.74,
    0.16, 0.04, 0.01, 0, 0, 0, 0, 0.19, 0.63, 0.15, 0.04, 0.01, 0, 0, 0, 0.05, 0.16,
    0.61, 0.15, 0.04, 0.01, 0, 0, 0.02, 0.04, 0.15, 0.6, 0.15, 0.04, 0.01, 0, 0, 0.01,
    0.04, 0.15, 0.6, 0.15, 0.04, 0, 0, 0, 0.01, 0.04, 0.15, 0.61, 0.16, 0, 0, 0, 0, 0.01,
    0.04, 0.15, 0.63, 0, 0, 0, 0, 0, 0.01, 0.04, 0.16, 1), 8, 8))),
  strata = c(s1 = 0.2, s2 = 0.8),
  days = paste0("D", 1:28),
  bin = rep(1, length(days) - 1),
  drop_out_rate = 0.01,
  sporatic_rate = 0.05,
  miss_not_dead_rate = 0.2
)
}
\arguments{
\item{n}{Number of samples.}

\item{fit}{Contains transition and prior parameters.}

\item{strata}{Named vector with probabilities to simulate strata.}

\item{days}{Names of the output columns that contain the score for each day.}

\item{bin}{The assigned bin for pooling together information across transitions. Must be a numeric vector of length=(length(days)-1). By defualt all transitions are pooled together.}

\item{drop_out_rate}{Parameter for simulating dropout. Rate is per day.}

\item{sporatic_rate}{Parameter for simulating missing.}

\item{miss_not_dead_rate}{Parameter to control missing but not dead rate.}
}
\value{
Returns wide format data. Possible niad os values may be:
\itemize{
 \item{Not missing:}{An integer from 1 to 8.}
 \item{Missing:}{NA}
 \item{Partially Missing:}{ range which may be code as a characters string such as '[1,7]' or '[1,2]'. Such a character string indicates that while the actual value is unknown, it is known that the value falls within the specified range. }
}
}
\description{
Simulate data for the purpose of testing the package.
}
\details{
This simulation function is used to generated data for examples and testing of the package.
}
\examples{
test <- sim_data(200)

}
