% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_comparison.R
\name{create_comparisons}
\alias{create_comparisons}
\title{create comparisons}
\usage{
create_comparisons(data, comparison = c("within", "among"))
}
\arguments{
\item{data}{a \code{data.frame} that is the names of the community and group names}

\item{comparison}{a \code{character}that is either \code{"within"} or \code{"among"} indicating
whether the comparisons are within a community and between groups or
among communities for the same groups.}
}
\description{
Creates a list with all of the comparisons needed to create  Bayesian and maximum-likelihood
estimates for proportion of niche similarities.
}
\examples{

# ---- load siber ----
library(SIBER)

# ---- create community names data frame ----
# uncomment to use
# str(demo.siber.data.2)

demo.siber.data.2$group_name <- as.factor(demo.siber.data.2$group)

demo.siber.data.2$group <- as.numeric(demo.siber.data.2$group_name) |>
as.character()

demo.siber.data.2$community_names <- as.factor(demo.siber.data.2$community)

demo.siber.data.2$community <- as.numeric(demo.siber.data.2$community_names) |>
as.character()

cg_names <- demo.siber.data.2 |>
dplyr::distinct(community, group, community_names, group_name)

# ---- create comparsions ----
create_comparisons(cg_names,
                  comparison = "within")

}
