% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_int.R
\name{gamma_int}
\alias{gamma_int}
\title{Incomplete Gamma Function}
\usage{
gamma_int(x, a, b)
}
\arguments{
\item{x}{gamma quantile}

\item{a}{shape parameter}

\item{b}{scale parameter}
}
\value{
A scalar value of the integral. For internal use only.
}
\description{
For internal use only. Use integration as a limit of a sum to numerically
 compute the incomplete gamma integral
}
\examples{
\donttest{
#####################
# Internal use only #
#####################
# Example usage in nimblewomble::wombling_matern1(...) or,
# nimblewomble::wombling_matern2(...)
require(nimble)

Gint = compileNimble(gamma_int)
Gint(x = 1, a = 1, b = 1)
}
}
\author{
Aritra Halder <aritra.halder@drexel.edu>, \cr
Sudipto Banerjee <sudipto@ucla.edu>
}
\keyword{gamma_int}
