% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_pooled_nca.R
\name{nca_control}
\alias{nca_control}
\title{Control options for non-compartmental analysis}
\usage{
nca_control(
  trapezoidal.rule = c("linear_up_log_down", "linear"),
  duration = NULL,
  nlastpoints = 3,
  slope.method = "bestfitforce"
)
}
\arguments{
\item{trapezoidal.rule}{Character. Method for trapezoidal AUC integration:
\itemize{
\item \code{"linear"} - Linear trapezoidal rule (default)
\item \code{"linear_up_log_down"} - Linear-up / log-down rule
}}

\item{duration}{Numeric. Optional. Duration of the observation window (same
units as time). Used to restrict the integration or define the evaluation
range.}

\item{nlastpoints}{Integer. Number of terminal points for half-life
regression (default = 3).}

\item{slope.method}{Character. Method for estimating the terminal slope
(lambdaz). Options are:
\itemize{
\item "bestfit": Performs automated terminal phase selection based on adjusted
R-squared. If no acceptable segment is found, lambdaz is returned as NA.
\item "bestfitforce": First attempts the "bestfit" method. If no valid lambdaz
is obtained, the function applies a fallback log-linear regression using
progressively fewer terminal points to force estimation. This is the default.
}}
}
\value{
A list with NCA control parameters.
}
\description{
Control options for non-compartmental analysis (NCA)
}
\examples{
nca_control()
}
\author{
Zhonghui Huang
}
