% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_sens_params.R
\name{sim_sens_2cmpt}
\alias{sim_sens_2cmpt}
\title{Parameter sweeping for a two-compartment pharmacokinetic model}
\usage{
sim_sens_2cmpt(
  dat,
  sim_ka = list(mode = "manual", values = NULL),
  sim_cl = list(mode = "manual", values = NULL),
  sim_vc = list(mode = "manual", values = NULL),
  sim_vp = list(mode = c("auto", "manual"), values = NULL),
  sim_q = list(mode = c("auto", "manual"), values = NULL, auto.strategy = c("scaled",
    "fixed")),
  route = c("iv", "oral"),
  verbose = TRUE
)
}
\arguments{
\item{dat}{Pharmacokinetic dataset.}

\item{sim_ka}{List specifying Ka (oral route only):
\itemize{
\item mode: must be "manual"
\item values: numeric vector
}}

\item{sim_cl}{List specifying clearance (CL):
\itemize{
\item mode: must be "manual"
\item values: numeric vector
}}

\item{sim_vc}{List specifying central volume (Vc):
\itemize{
\item mode: must be "manual"
\item values: numeric vector
}}

\item{sim_vp}{List specifying peripheral volume (Vp):
\itemize{
\item mode: "manual" or "auto"
\item values: numeric vector if manual
}}

\item{sim_q}{List specifying inter-compartmental clearance (Q):
\itemize{
\item mode: "manual" or "auto"
\item values: numeric vector if manual
}}

\item{route}{Dosing route, either "iv" or "oral". Default is "iv".}

\item{verbose}{Logical (default = TRUE).
Controls whether progress information is displayed during parameter sweeping.
When TRUE, a dynamic progress bar is shown using the \code{progressr} package to
indicate simulation status and elapsed time.
When FALSE, progress output is suppressed and the function runs silently.}
}
\value{
A data frame containing parameter combinations with model fit metrics.
}
\description{
Performs parameter sweeping by varying pharmacokinetic parameters in a
two-compartment model under IV or oral dosing. Model fit is evaluated across
combinations of CL, Vc, Vp, Q, and Ka (oral only).
}
\details{
The function generates a parameter grid and performs model fitting for each
combination using \code{Fit_2cmpt_iv} or \code{Fit_2cmpt_oral}. Parameters can be
specified manually or automatically derived. Model predictions and fit metrics
are computed for each simulation to assess parameter sensitivity.
}
\examples{
\donttest{
out <- sim_sens_2cmpt(
  dat = Bolus_2CPT[Bolus_2CPT$ID<50,],
  sim_cl = list(mode = "manual", values = 4),
  sim_vc = list(mode = "manual", values = 50),
  sim_vp = list(mode = "auto"),
  sim_q  = list(mode = "auto"),
  sim_ka = list(mode = "manual", values = NA),
  route = "iv",verbose=FALSE
)
head(out[out$rRMSE2==min(out$rRMSE2),])
}
}
\seealso{
\code{\link{Fit_2cmpt_iv}}, \code{\link{Fit_2cmpt_oral}}
}
\author{
Zhonghui Huang
}
