% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSscard3.R
\name{SSscard3}
\alias{SSscard3}
\alias{scard3}
\title{self start for smooth cardinal temperature response}
\usage{
scard3(x, tb, to, tm, curve = 2)

SSscard3(x, tb, to, tm, curve = 2)
}
\arguments{
\item{x}{input vector (x) which is normally \sQuote{temperature}.}

\item{tb}{base temperature}

\item{to}{optimum temperature}

\item{tm}{maximum temperature}

\item{curve}{curvature (default is 2)}
}
\value{
scard3: vector of the same length as x using a scard3 function
}
\description{
Self starter for smooth cardinal temperature response function
}
\details{
An example application can be found in (doi:10.1016/j.envsoft.2014.04.009)

This function is described in Archontoulis and Miguez (2015) - (doi:10.2134/agronj2012.0506) - Equation 5.1 in Table 1.
}
\examples{
\donttest{
## A temperature response function
require(ggplot2)
set.seed(1234)
x <- 1:50
y <- scard3(x, 13, 25, 36) + rnorm(length(x), sd = 0.05)
dat1 <- data.frame(x = x, y = y)
fit1 <- nls(y ~ SSscard3(x, tb, to, tm), data = dat1)

ggplot(data = dat1, aes(x, y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit1)))
}
}
\author{
Caio dos Santos and Fernando Miguez
}
