% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlsic.R
\name{pnull}
\alias{pnull}
\title{Particular least-squares solution and Null-space basis}
\usage{
pnull(A, b = NULL, qrat = NULL, rcond = 1e+10, keepqr = FALSE)
}
\arguments{
\item{A}{matrix (or its QR decomposition) such that \code{A\%*\%B=0}
where B is a basis of \code{Kern(A)} (aka Null-space).}

\item{b}{is the right hand side of the least squares system \code{Ax=b}.}

\item{qrat}{is QR decomposition of \code{t(A)}.}

\item{rcond}{maximal condition number for rank definition}

\item{keepqr}{if TRUE strore qr and qrat as attribute of B}
}
\value{
alist with xp and B, particular solution and numeric matrix
whose columns are basis vectors. If requested, attributes 'qr' and
'qrat' of B contain QR decomposition of \code{A} and \code{t(A)}
respectively.
}
\description{
use Lapack to find a particular solution \code{xp} of under-determined least
squares system \code{Ax=b} and build null space basis \code{B} of \code{A}
(derived from MASS::Null). In such a way, a general solution is given by
\code{x=xp+Bz} where z is an arbitrary vector of size \code{ncol(A)-rank(A)}.
}
\examples{
A=diag(nrow=3L)[1:2,,drop=FALSE]
b=A\%*\%(1:3)
res=pnull(A, b)
stopifnot(all.equal(res$xp, c(1:2,0)))
stopifnot(all.equal(c(res$B), c(0,0,1)))
}
\seealso{
\link[MASS:Null]{MASS::Null} \link{Nulla}
}
