% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aff.R
\name{Aff}
\alias{Aff}
\title{Aff}
\usage{
Aff(W, b)
}
\arguments{
\item{W}{An \eqn{m \times n} matrix representing the weight of the affine
neural network}

\item{b}{An \eqn{m \times 1} vector representing the bias of the affine
neural network}
}
\value{
Returns the network \eqn{((W,b))} representing an affine neural network. Also
denoted as \eqn{\mathsf{Aff}_{W,b}}
See also \code{\link{Cpy}} and \code{\link{Sum}}.
}
\description{
The function that returns \eqn{\mathsf{Aff}} neural networks.
}
\examples{
Aff(4, 5)
c(5, 6, 7, 8, 9, 10) |>
  matrix(2, 3) |>
  Aff(5)

}
\references{
Definition 2.3.1. Jentzen, A., Kuckuck, B., and von Wurstemberger, P. (2023).
Mathematical introduction to deep learning: Methods, implementations,
and theory. \url{https://arxiv.org/abs/2310.20360}

And especially:

Definition 2.8. Rafi S., Padgett, J.L., Nakarmi, U. (2024) Towards an Algebraic Framework For
Approximating Functions Using Neural Network Polynomials
\url{https://arxiv.org/abs/2402.01058}
}
