% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_creator.R
\name{create_nn}
\alias{create_nn}
\title{create_nn}
\usage{
create_nn(layer_architecture)
}
\arguments{
\item{layer_architecture}{a list specifying the width of each layer}
}
\value{
An ordered list of ordered pairs of \eqn{(W,b)}. Where \eqn{W} is the matrix
representing the weight matrix at that layer and \eqn{b} the bias vector. Entries
on the matrix come from a standard normal distribution.
}
\description{
Function to create a list of lists for neural network layers
}
\examples{
create_nn(c(8, 7, 8))
create_nn(c(4,4))

}
\references{
Definition 2.1 in Rafi S., Padgett, J.L., Nakarmi, U. (2024) Towards an Algebraic Framework For
Approximating Functions Using Neural Network Polynomials
\url{https://arxiv.org/abs/2402.01058}

Which in turn is a modified version of the one found in:

Definition 2.3. Grohs, P., Hornung, F., Jentzen, A. et al.
Space-time error estimates for deep neural network approximations
for differential equations. (2019).
\url{https://arxiv.org/abs/1908.03833}.
}
