% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/055_asy_int_an.R
\name{asy_int_an}
\alias{asy_int_an}
\alias{asy_int_an.default}
\alias{asy_int_an.formula}
\title{Asymmetric interval-based attribute noise}
\usage{
\method{asy_int_an}{default}(x, y, level, nbins = 10, sortid = TRUE, ...)

\method{asy_int_an}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double vector with the noise levels in [0,1] to be introduced into each attribute.}

\item{nbins}{an integer with the number of bins to create (default: 10).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per attribute.}
\item{idnoise}{an integer vector list with the indices of noisy samples per attribute.}
\item{numclean}{an integer vector with the amount of clean samples per attribute.}
\item{idclean}{an integer vector list with the indices of clean samples per attribute.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Asymmetric interval-based attribute noise} into a classification dataset.
}
\details{
\emph{Asymmetric interval-based attribute noise} corrupts (\code{level}[i]·100)\% of the values for
each attribute \emph{A}[i] in the dataset. In order to corrupt an attribute \emph{A}[i], (\code{level}[i]·100)\% of the
samples in the dataset are chosen. To corrupt a value in numeric
attributes, the attribute is split into equal-frequency intervals, one of its closest
intervals is picked out and a random valuen within the interval
is chosen as noisy. For nominal attributes, a random value within the domain is selected.
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- asy_int_an(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], 
                         level = c(0.1, 0.2))

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- asy_int_an(formula = Species ~ ., data = iris2D,
                         level = c(0.1, 0.2))

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
M. V. Mannino, Y. Yang, and Y. Ryu. 
\strong{Classification algorithm sensitivity to training data with non representative attribute noise}. 
\emph{Decision Support Systems}, 46(3):743-751, 2009.
\doi{10.1016/j.dss.2008.11.021}.
}
\seealso{
\code{\link{asy_uni_an}}, \code{\link{symd_gimg_an}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
