% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/003_asy_uni_ln.R
\name{asy_uni_ln}
\alias{asy_uni_ln}
\alias{asy_uni_ln.default}
\alias{asy_uni_ln.formula}
\title{Asymmetric uniform label noise}
\usage{
\method{asy_uni_ln}{default}(x, y, level, order = levels(y), sortid = TRUE, ...)

\method{asy_uni_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double vector with the noise levels in [0,1] to be introduced into each class.}

\item{order}{a character vector indicating the order of the classes (default: \code{levels(y)}).}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Asymmetric uniform label noise} into a classification dataset.
}
\details{
\emph{Asymmetric uniform label noise} randomly selects (\code{level}[i]·100)\% of the samples
of each class \emph{C}[i] in the dataset -the order of the class labels is determined by
\code{order}. Finally, the labels of these samples are randomly
replaced by other different ones within the set of class labels.
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- asy_uni_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], 
                    level = c(0.1, 0.2, 0.3), order = c("virginica", "setosa", "versicolor"))

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- asy_uni_ln(formula = Species ~ ., data = iris2D, 
                     level = c(0.1, 0.2, 0.3), order = c("virginica", "setosa", "versicolor"))

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
Z. Zhao, L. Chu, D. Tao, and J. Pei. 
\strong{Classification with label noise: a Markov chain sampling framework}. 
\emph{Data Mining and Knowledge Discovery}, 33(5):1468-1504, 2019.
\doi{10.1007/s10618-018-0592-8}.
}
\seealso{
\code{\link{maj_udir_ln}}, \code{\link{asy_def_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
