% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_genes_transcript.R
\name{filter_genes_transcript}
\alias{filter_genes_transcript}
\title{Function to filter the gene table for the transcript approach}
\usage{
filter_genes_transcript(
  genes,
  expression.matrix,
  noise.thresholds,
  filter.by = c("gene", "exon"),
  ...
)
}
\arguments{
\item{genes}{a tibble of the exons extracted from the gtf file;
(usually the the output of \code{\link{cast_gtf_to_genes}})}

\item{expression.matrix}{the expression matrix, usually
calculated by \code{\link{calculate_expression_similarity_transcript}}}

\item{noise.thresholds}{a vector of expression thresholds by sample}

\item{filter.by}{Either "gene" (default) or "exon"; if filter.by="gene", a gene
(as determined by its ENSEMBL id) is removed
if and only if all of its exons are below the corresponding noise thresholds;
if filter.by="exon", then each exon is individually removed
if it is below the corresponding noise thresholds.}

\item{...}{arguments passed on to other methods}
}
\value{
Returns a filtered tibble of exons, with the noise removed.
}
\description{
This function is used to filter the gene table (usually created with
\code{\link{cast_gtf_to_genes}}), only keeping genes above the noise thresholds.
It uses as input the gene table (usually containing individual exons),
an expression matrix for each of these and a vector of abundance thresholds.
This function is used internally by \code{\link{remove_noise_from_bams}} to determine
which genes to retain.
}
\examples{
bams <- rep(system.file("extdata", "ex1.bam", package="Rsamtools", mustWork=TRUE), 2)
genes <- data.frame("id" = 1:2,
                    "gene_id" = c("gene1", "gene2"),
                    "seqid" = c("seq1", "seq2"),
                    "start" = 1,
                    "end" = 1600)
noise.thresholds <- c(0, 1)
expression.summary = calculate_expression_similarity_transcript(
  bams = bams,
  genes = genes,
  mapq.unique = 99
)
filter_genes_transcript(
    genes = genes,
    expression.matrix = expression.summary$expression.matrix,
    noise.thresholds = noise.thresholds,
)

}
