# 📈 nonparTrendR

`nonparTrendR` is an R package implementing a nonparametric trend test for independent and dependent samples, based on Bathke (2009). It detects consistent monotonic trends (increasing or decreasing) across time points or ordered groups, while accounting for within-subject correlations in repeated measures.

---

## ✨ Features
- 📌 Supports both independent and repeated measures designs.
- 📊 Rank-based test statistic (ν̂) with two-sided and directional alternatives.
- 🔗 Handles within-subject dependencies in longitudinal data.
- ✅ Returns standard `htest` objects for easy integration.

---

## 📚 Reference
Bathke, A. C. (2009).  
*A unified approach to nonparametric trend tests for dependent and independent samples.*  
Metrika, 69(1), 17–29.

---

## 🛠 Installation

```R
# Install from CRAN (after release)
install.packages("nonparTrendR")

# Or install development version from GitHub
devtools::install_github("yourusername/nonparTrendR")
```

## 🚀 Quick Example

### Independent samples

```R
library(nonparTrendR)

data_indep <- list(
  c(6.62, 6.65, 5.78),  # Group 1
  c(6.25, 6.95, 5.61),  # Group 2
  c(7.11, 5.68, 6.23)   # Group 3
)

nonparTrendR_test(data_indep, type = "I", alternative = "increasing")
```

### Dependent samples

```R

data_dep <- matrix(c(
  8, 6, 5, 5, 4,
  7, 6, 6, 6, 6,
  6, 5, 5, 4, 2
), nrow = 3, byrow = TRUE)

nonparTrendR_test(data_dep, type = "D", alternative = "decreasing")

```

## 🧪 Example Use Cases

- Clinical trials (longitudinal symptom scores)
- Industrial process monitoring
- Customer metrics over time
- Seasonal survey responses