% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.ConfInt.R
\name{Plot.ConfInt}
\alias{Plot.ConfInt}
\title{Bar plots for two-sided confidence intervals}
\usage{
Plot.ConfInt(object, level, side="two.sided",
adjust=NULL)
}
\arguments{
\item{object}{a fitted model object from ncda().}

\item{level}{the confidence level required.}

\item{side}{a character string specifying the side of the confidence bound,
must be one of "two.sided" (default), "left" or "right".}

\item{adjust}{an optional character string specifying the multiple adjustment method,
by default there is no adjustment, if specified, must be one of "Bonferroni" or
"Working-Hotelling". You can specify just the initial letter.}
}
\value{
Bar plots.
}
\description{
Bar plots for two-sided confidence intervals
}
\examples{
skin_analysis <- ncda(score~tx, skin, intervention, subject,
                      indicator=c("control","treatment"),
                      Contrast=matrix(c(1,-1), nrow = 1))
Plot.ConfInt(skin_analysis,0.95,"Two-Sided")
\donttest{
ARTIS_analysis <- ncda(emot_pqol~tx, ARTIS, intervention, homeid,
                       indicator = c("0","1"))
Plot.ConfInt(ARTIS_analysis,0.95,"Two-Sided")
Plot.ConfInt(ARTIS_analysis,0.95,"Two-Sided","Bonferroni")
Plot.ConfInt(ARTIS_analysis,0.95,"Two-Sided","Working-Hotelling")
}
}
