% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous_functions_1-1.R
\name{pchaz}
\alias{pchaz}
\title{Calculate survival for piecewise constant hazard}
\usage{
pchaz(Tint, lambda)
}
\arguments{
\item{Tint}{vector of length \eqn{k+1}, for the boundaries of \eqn{k} time intervals (presumably in days) with piecewise constant hazard. The boundaries should be increasing and the first one should
be \code{0}, the last one should be larger than the assumed trial duration.}

\item{lambda}{vector of length \eqn{k} with the piecewise constant hazards for the intervals specified via \code{Tint}.}
}
\value{
A list with class \code{mixpch} containing the following components:
\describe{
\item{\code{haz}}{Values of the hazard function over discrete times t.}
\item{\code{cumhaz}}{Values of the cumulative hazard function over discrete times t.}
\item{\code{S}}{Values of the survival function over discrete times t.}
\item{\code{F}}{Values of the distribution function over discrete times t.}
\item{\code{t}}{Time points for which the values of the different functions are calculated.}
\item{\code{Tint}}{Input vector of boundaries of time intervals.}
\item{\code{lambda}}{Input vector of piecewise constant hazards.}
\item{\code{funs}}{A list with functions to calculate the hazard, cumulative hazard, survival, pdf and cdf over arbitrary continuous times.}
}
}
\description{
Calculates hazard, cumulative hazard, survival and distribution function
based on hazards that are constant over pre-specified time-intervals.
}
\details{
Given \eqn{k} time intervals \eqn{[t_{j-1},t_j), j=1,\dots,k} with
\eqn{0 =  t_0 < t_1 \dots < t_k}, the function assume constant hazards \eqn{\lambda_{j}} at each interval.
The resulting hazard function is
\eqn{\lambda(t) =\sum_{j=1}^k \lambda_{j} {1}_{t \in [t_{j-1},t_j)}},
the cumulative hazard function is\\
\eqn{\Lambda(t) = \int_0^t \lambda(s) ds =\sum_{j=1}^k \left( (t_j-t_{j-1})\lambda_{j} {1}_{t > t_j} + (t-t_{j-1}) \lambda_{j} {1}_{t \in [t_{j-1},t_j) } \right)}
and the survival function \eqn{S(t) = e^{-\Lambda(t)}}.
The output includes the functions values calculated for all integer time points
between 0 and the maximum of \code{Tint}.
Additionally, a list with functions is also given to calculate the values at any arbitrary point \eqn{t}.
}
\examples{
pchaz(Tint = c(0, 40, 100), lambda=c(.02, .05))
}
\references{
Robin Ristl, Nicolas Ballarini, Heiko Götte, Armin Schüler, Martin Posch, Franz König. Delayed treatment effects, treatment switching and
heterogeneous patient populations: How to design and analyze RCTs in oncology. Pharmaceutical statistics. 2021; 20(1):129-145.
}
\seealso{
\code{\link{subpop_pchaz}}, \code{\link{pop_pchaz}}, \code{\link{plot.mixpch}}
}
\author{
Robin Ristl, \email{robin.ristl@meduniwien.ac.at}, Nicolas Ballarini
}
