% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_events_and_duration.R
\name{exp_duration}
\alias{exp_duration}
\title{Expected duration}
\usage{
exp_duration(
  arm0 = NA,
  arm1 = NA,
  d,
  search_start = 10,
  search_prec = 0.01,
  max_duration = 1000
)
}
\arguments{
\item{arm0}{object of class 'arm'.}

\item{arm1}{object of class 'arm'.}

\item{d}{vector of number of events.}

\item{search_start}{value at which the search for duration tau starts.}

\item{search_prec}{value controlling the desired precision before
terminating the search.}

\item{max_duration}{maximum \eqn{\tau} for consideration.}
}
\value{
expected trial duration.
}
\description{
Given one or two treatment arms, calculate the time \eqn{\tau} at which
the expected number of events equals \eqn{d}.
}
\examples{
arm0 <- create_arm(size=120, accr_time=6, surv_scale=0.05, loss_scale=0.005, follow_time=12)
arm1 <- create_arm(size=120, accr_time=6, surv_scale=0.03, loss_scale=0.005, follow_time=12)
exp_duration(arm0, d=61)
exp_duration(arm0, arm1, d=103)
exp_duration(arm0, d=c(35,61))
exp_duration(arm0, arm1, d=c(57,103))
}
\seealso{
\code{\link{exp_events}} for calculating expected events d at time tau,
  \code{\link{create_arm}} and \code{\link{create_arm_lachin}}
  for creating an object of class 'arm'.
}
