% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nrba-package.R
\docType{package}
\name{nrba-package}
\alias{nrba}
\alias{nrba-package}
\title{nrba: Methods for Conducting Nonresponse Bias Analysis (NRBA)}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Facilitates nonresponse bias analysis (NRBA) for survey data. Such data may arise from a complex sampling design with features such as stratification, clustering, or unequal probabilities of selection. Multiple types of analyses may be conducted: comparisons of response rates across subgroups; comparisons of estimates before and after weighting adjustments; comparisons of sample-based estimates to external population totals; tests of systematic differences in covariate means between respondents and full samples; tests of independence between response status and covariates; and modeling of outcomes and response status as a function of covariates. Extensive documentation and references are provided for each type of analysis. Krenzke, Van de Kerckhove, and Mohadjer (2005) \url{http://www.asasrms.org/Proceedings/y2005/files/JSM2005-000572.pdf} and Lohr and Riddles (2016) \url{https://www150.statcan.gc.ca/n1/en/pub/12-001-x/2016002/article/14677-eng.pdf?st=q7PyNsGR} provide an overview of the methods implemented in this package.
}
\author{
\strong{Maintainer}: Ben Schneider \email{BenjaminSchneider@westat.com} (\href{https://orcid.org/0000-0002-0406-8470}{ORCID})

Authors:
\itemize{
  \item Jim Green \email{JimGreen@westat.com}
  \item Shelley Brock \email{ShelleyBrock@westat.com} (Author of original SAS macro, WesNRBA)
  \item Tom Krenzke \email{TomKrenzke@westat.com} (Author of original SAS macro, WesNRBA)
  \item Michael Jones \email{MichaelJones@westat.com} (Author of original SAS macro, WesNRBA)
  \item Wendy Van de Kerckhove (Author of original SAS macro, WesNRBA)
  \item David Ferraro (Author of original SAS macro, WesNRBA)
  \item Laura Alvarez-Rojas (Author of original SAS macro, WesNRBA)
  \item Katie Hubbell \email{KatieHubbell@westat.com} (Author of original SAS macro, WesNRBA)
}

Other contributors:
\itemize{
  \item Westat [copyright holder]
}

}
\keyword{internal}
