% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round.R
\name{round2}
\alias{round2}
\alias{round_any}
\title{Rounding}
\usage{
round2(x, digits = 0, ...)

round_any(x, accuracy, f = round2, ...)
}
\arguments{
\item{x}{A vector of digits.}

\item{digits}{The number of decimal places to round to.}

\item{accuracy}{Number to round to.}

\item{f}{A function to round (e.g., \code{round}, \code{ceiling}, \code{floor}).
efaults to \code{round2}.}

\item{\ldots}{ignored.}
}
\value{
\code{round2} - Returns numeric vector half rounded up.

\code{round_any} - Returns a numeric vector or rounded fractional values.
}
\description{
\code{round2} - By default R's \code{round} function uses the 'round half to
even' method.  This function (taken from https://stackoverflow.com/a/12688836/1000343)
rounds half up.

\code{round_any} - This tooling lets you round to fractional values, not
just whole numbers.  Code adapted from https://stackoverflow.com/a/8665247/1000343.
}
\examples{
data.frame(
    orig = .5 + (0:8),
    round = round(.5 + (0:8)),
    round2 = round2(.5 + (0:8))
)

round_any(c(.123, 1.234, 4, 4.715), .5)
round_any(c(.123, 1.234, 4, 4.715), .25)
}
\references{
https://stackoverflow.com/a/12688836/1000343 \cr
https://stackoverflow.com/a/8665247/1000343
}
\author{
Kohske Takahashi
}
