% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dictionary.R
\name{read_dictionary}
\alias{read_dictionary}
\title{Download data dictionary from OD surveys databases}
\usage{
read_dictionary(
  city = "São Paulo",
  year = 2017,
  harmonize = FALSE,
  language = "pt"
)
}
\arguments{
\item{city}{Character. City of reference. Defaults to "São Paulo".}

\item{year}{Numeric. Year of reference in the format \code{yyyy}. Defaults to
\code{1977}.}

\item{harmonize}{Logical. When \code{FALSE} (Default), the function returns the raw
data. If \code{TRUE}, the function returns harmonized data to the same
city, across all the years.}

\item{language}{Character. The language of data dictionary to be opened.
Options include \code{c("pt", "en", "es")}.}
}
\value{
A \code{"data.frame"} object.
}
\description{
Return the data dictionary of a specific Origin
Destination Survey, if available. This dictionary is intended to be used to
understand the data downloaded using the \code{odbr::read_od} function. It will
contain the list of variables and, for each variable, a simple description,
the available categories and its class (factor, numeric, etc).
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(odbr)

# return data dictionary from OD Surveys, as data.frame, at a given city and year
df <- read_dictionary(
  city = "Sao Paulo",
  year = 2017,
  harmonize = FALSE,
  language = "pt"
)
\dontshow{\}) # examplesIf}
}
\concept{Documentation}
