% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_outlier_threshold.R
\name{set_outlier_threshold}
\alias{set_outlier_threshold}
\title{Set a threshold for outlier detection}
\usage{
set_outlier_threshold(pc_pcnorm, p_rate = 0.001, trials = 500)
}
\arguments{
\item{pc_pcnorm}{The scores of the first two pricipal components returned by \code{\link{get_pc_space}}}

\item{p_rate}{False positive rate. Default value is set to 0.001}

\item{trials}{Number of trials to generate the extreme value distirbution. Default value is set to 500.}
}
\value{
Returns a threshold to determine outlying series in the next window  consists with a collection of
time series.
}
\description{
This function forecasts a boundary for the typical behaviour using a representative sample
of the typical behaviour of a given system. An approach based on extreme value theory is used for this boundary
prediction process.
}
\examples{
\donttest{
# Generate training dataset
set.seed(123)
nobs <- 500
nts <- 50
train_data <- ts(apply(matrix(ncol = nts, nrow = nobs), 2, function(nobs){10 + rnorm(nobs, 0, 3)}))
features <- extract_tsfeatures(train_data)
pc <- get_pc_space(features)
threshold <- set_outlier_threshold(pc$pcnorm)
threshold$threshold_fnx
}

}
\references{
Clifton, D. A., Hugueny, S., & Tarassenko, L. (2011). Novelty detection with multivariate extreme value statistics.
Journal of signal processing systems, 65 (3),371-389.

Talagala, P., Hyndman, R., Smith-Miles, K., Kandanaarachchi, S., & Munoz, M. (2018).
Anomaly detection in streaming nonstationary temporal data (No. 4/18).
Monash University, Department of Econometrics and Business Statistics.
}
\seealso{
\code{\link{find_odd_streams}},  \code{\link{extract_tsfeatures}}, \code{\link{get_pc_space}},
\code{\link{gg_featurespace}}
}
