% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_block_objects.R
\name{block_pour_docx}
\alias{block_pour_docx}
\title{External Word document placeholder}
\usage{
block_pour_docx(file)
}
\arguments{
\item{file}{external docx file path}
}
\description{
Pour the content of a docx file in the resulting docx
from an 'R Markdown' document.
}
\examples{
library(officer)
docx <- tempfile(fileext = ".docx")
doc <- read_docx()
doc <- body_add(doc, iris[1:20,], style = "table_template")
print(doc, target = docx)

target <- tempfile(fileext = ".docx")
doc_1 <- read_docx()
doc_1 <- body_add(doc_1, block_pour_docx(docx))
print(doc_1, target = target)
}
\seealso{
Other block functions for reporting: 
\code{\link{block_caption}()},
\code{\link{block_gg}()},
\code{\link{block_list}()},
\code{\link{block_section}()},
\code{\link{block_table}()},
\code{\link{block_toc}()},
\code{\link{fpar}()},
\code{\link{plot_instr}()},
\code{\link{unordered_list}()}
}
\concept{block functions for reporting}
