% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08-chart.R
\name{chart_op_age}
\alias{chart_op_age}
\alias{chart_op_muac}
\alias{chart_op_mf}
\alias{chart_op_dds}
\alias{chart_op_k6}
\alias{chart_op_adl}
\alias{chart_op_wash}
\alias{chart_op_csid}
\alias{chart_op_wg}
\alias{chart_op_hhs}
\alias{chart_op_income}
\title{Plot RAM-OP indicators}
\usage{
chart_op_age(
  x,
  save_chart = TRUE,
  filename = file.path(tempdir(), "populationPyramid")
)

chart_op_muac(x, save_chart = TRUE, filename = file.path(tempdir(), "chart"))

chart_op_mf(x, save_chart = TRUE, filename = file.path(tempdir(), "chart"))

chart_op_dds(x, save_chart = TRUE, filename = file.path(tempdir(), "chart"))

chart_op_k6(x, save_chart = TRUE, filename = file.path(tempdir(), "chart"))

chart_op_adl(x, save_chart = TRUE, filename = file.path(tempdir(), "chart"))

chart_op_wash(x, save_chart = TRUE, filename = file.path(tempdir(), "chart"))

chart_op_csid(x, save_chart = TRUE, filename = file.path(tempdir(), "chart"))

chart_op_wg(x, save_chart = TRUE, filename = file.path(tempdir(), "chart"))

chart_op_hhs(x, save_chart = TRUE, filename = file.path(tempdir(), "chart"))

chart_op_income(x, save_chart = TRUE, filename = file.path(tempdir(), "chart"))
}
\arguments{
\item{x}{Indicators dataset produced by \code{\link[=create_op]{create_op()}}}

\item{save_chart}{Logical. Should chart be saved? Default is TRUE.}

\item{filename}{Prefix to add to output chart filename or a directory
path to save output to instead of working directory. Default is a path to
a temporary directory and a suggested filename. Ignored if \code{save_chart}
is FALSE.}
}
\value{
The respective plot in PNG format saved in the specified path if
\code{filename} is a path unless when \code{save_chart} is FALSE in which case the
plot is shown on current graphics device
}
\description{
The plots include:
\itemize{
\item Age by sex (pyramid plot) - a wrapper function to the \code{\link[=pyramid_plot]{pyramid_plot()}}
function to create an age by sex pyramid plot
\item Distribution of MUAC (overall and by sex) - histogram of MUAC distribution
\item Distribution of meal frequency (overall and by sex)
\item Distribution of dietary diversity score (overall and by sex)
\item Distribution of K6 (overall and by sex)
\item Distribution of ADL (overall and by sex)
\item Plot of WASH indicators
\item Plot of dementia screen (CSID) indicators
\item Plot of disability (Washington Group - WG) indicators
\item Plot of household hunger scale (HHS) indicators
\item Plot of income indicators
}
}
\examples{
# Create age by sex pyramid plot using indicators.ALL dataset
chart_op_age(x = indicators.ALL)

# Create MUAC histogram using indicators.ALL dataset
chart_op_muac(x = indicators.ALL)

# Create meal frequency chart using indicators.ALL dataset
chart_op_mf(x = indicators.ALL)

# Create DDS chart using indicators.ALL dataset
chart_op_dds(x = indicators.ALL)

# Create chart using indicators.ALL dataset
chart_op_k6(x = indicators.ALL)

# Create chart using indicators.ALL dataset
chart_op_adl(x = indicators.ALL)

# Create chart using indicators.ALL dataset
chart_op_wash(x = indicators.ALL)

# Create chart using indicators.ALL dataset
chart_op_csid(x = indicators.ALL)

# Create chart using indicators.ALL dataset
chart_op_wg(x = indicators.ALL)

# Create chart using indicators.ALL dataset
chart_op_hhs(x = indicators.ALL)

# Create chart using indicators.FEMALES and indicators.MALES
# dataset
chart_op_income(x = indicators.ALL)

}
