% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwas_power.R
\name{plot_gwas_power}
\alias{plot_gwas_power}
\title{plot_gwas_power}
\usage{
plot_gwas_power(
  trait_type = "bt",
  n_cases = NULL,
  n_controls = NULL,
  sd_trait = NULL,
  N = NULL,
  maf_levels = c(0.01, 0.02, 0.05, 0.1, 0.2, 0.5),
  or_range = seq(1.01, 2, 0.001),
  effect_size = seq(0.01, 0.3, 0.001),
  alpha = 5e-08,
  plot_title = NULL,
  save_plot = TRUE,
  output_graphics = "png",
  width = 17,
  height = 9,
  dpi = 600
)
}
\arguments{
\item{trait_type}{Character string specifying trait type: "bt" for binary (case-control) or "qt" for quantitative traits. Default: \code{"bt"}.}

\item{n_cases}{Number of cases in the study (required if \code{trait_type = "bt"}).}

\item{n_controls}{Number of controls in the study (required if \code{trait_type = "bt"}).}

\item{sd_trait}{Numeric, standard deviation of the quantitative trait (required if \code{trait_type = "qt"}).}

\item{N}{Numeric, total sample size for quantitative traits (required if \code{trait_type = "qt"}).}

\item{maf_levels}{A numeric vector of Minor Allele Frequencies (MAFs) to test.
Default: \code{c(0.01, 0.02, 0.05, 0.10, 0.20, 0.50)}.}

\item{or_range}{A numeric vector specifying the sequence of Odds Ratios (ORs) to test.
Default: \code{seq(1.01, 2.00, 0.001)}. Used when \code{trait_type = "bt"}.}

\item{effect_size}{A numeric vector specifying the sequence of effect sizes (beta) to test for quantitative traits.
Default: \code{seq(0.01, 0.30, 0.001)}. Used when \code{trait_type = "qt"}.}

\item{alpha}{The significance level (alpha) for the power calculation.
Default: \code{5e-8}.}

\item{plot_title}{A string for the plot title.
Default: \code{Cases / Controls} for binary traits or \verb{Sample Size} for quantitative traits.}

\item{save_plot}{Logical, whether to save the plot to a file. If \code{FALSE}, the
plot object is only returned. Default: \code{TRUE}.}

\item{output_graphics}{The file format for saving the plot. Currently supports
"png" and "pdf". Default: "png".}

\item{width}{The width of the saved plot in inches. Default: 17.}

\item{height}{The height of the saved plot in inches. Default: 9.}

\item{dpi}{The resolution of the saved plot in dots per inch. Default: 600.}
}
\value{
A list containing two elements:
\item{plot}{The ggplot object for the power plot.}
\item{power_data}{A data.table containing the full results from the power analysis.}
}
\description{
Generates a statistical power analysis plot for GWAS studies.
Supports binary (case-control) traits over a range of odds ratios and minor allele frequencies,
and quantitative traits over a range of effect sizes and minor allele frequencies.
This function uses the 'genpwr' package for calculations and creates a highly customized ggplot.
}
\details{
This function automates the process of calculating and visualizing GWAS power for both
binary (case-control) and quantitative traits. For binary traits, it analyzes power across
odds ratios, while for quantitative traits, it analyzes power across effect sizes.
It highlights the minimum OR/effect size required to achieve 80\% power for the lowest and
third-lowest MAF levels, adding dashed lines and color-coded labels for clarity.
}
\section{Font Information}{

The MetroSans font included in this package is intended for academic research and non-commercial use only. For commercial use, please contact the font copyright holder.

The font files are included in the package's inst/extdata directory and are automatically loaded for plotting.
}

\examples{
\donttest{
  # Binary trait example (case-control)
  power_results_bt <- plot_gwas_power(
    trait_type = "bt",
    n_cases = 4324,
    n_controls = 93945,
    save_plot = FALSE
  )

  # Quantitative trait example
  power_results_qt <- plot_gwas_power(
    trait_type = "qt",
    sd_trait = 0.09365788681305078,
    N = 10000,
    maf_levels = c(0.01, 0.02, 0.05, 0.10, 0.20, 0.50),
    effect_size = seq(0.01, 0.10, 0.001),
    save_plot = FALSE
  )

  # Access the ggplot object and data
  # print(power_results_bt$plot)
  # print(power_results_bt$power_data)
}

}
\author{
Zhen Lu \href{mailto:luzh29@mail2.sysu.edu.cn}{luzh29@mail2.sysu.edu.cn}
}
