% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runifMatrix.r
\name{runifMatrix}
\alias{runifMatrix}
\title{Matrix of random values, possibly with standardization by row or column}
\usage{
runifMatrix(nrow, ncol, min = 0, max = 1, stand = NULL)
}
\arguments{
\item{nrow, ncol}{Number of rows and columns.}

\item{min, max}{Minimum and maximum value of values.}

\item{stand}{Any of:
\itemize{
\item \code{NULL} (default): No standardization.
\item \code{'rows'}: Standardize so rows sum to 1.
\item \code{'columns'}: Standardize so columns sum to 1.
\item \code{'matrix'}: Standardize so all values sum to 1.
}
Partial matching is used and case is ignored.}
}
\value{
A numeric matrix.
}
\description{
This function creates a matrix populated by random uniform values and (at the user's discretion), standardizes the rows, columns, or entire matrix so values sum to 1.
}
\examples{

rows <- 4
cols <- 3

runifMatrix(rows, cols)

standByRows <- runifMatrix(rows, cols, stand = 'r')
standByRows
rowSums(standByRows)

standByCols <- runifMatrix(rows, cols, stand = 'c')
standByCols
colSums(standByCols)

standByMe <- runifMatrix(rows, cols, stand = 'm')
standByMe
sum(standByMe) # whenever you're in trouble

}
