% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elements.R
\name{svg_rect}
\alias{svg_rect}
\title{Addition of a \code{rect} element}
\usage{
svg_rect(
  svg,
  x,
  y,
  width,
  height,
  rx = NULL,
  ry = NULL,
  stroke = NULL,
  stroke_width = NULL,
  fill = NULL,
  opacity = NULL,
  attrs = list(),
  anims = list(),
  filters = list(),
  id = NULL
)
}
\arguments{
\item{svg}{The \code{svg} object that is created using the \code{\link[=SVG]{SVG()}} function.}

\item{x, y}{The \code{x} and \code{y} positions of the upper left point of the rectangle
to be drawn. The \code{x} and \code{y} values are relative to upper left of the SVG
drawing area.}

\item{width, height}{The \code{width} and \code{height} of the element that is to be
drawn. The \code{width} is the distance in the 'x' direction from point \code{x}
(proceeding right) and the \code{height} is the distance in the 'y' direction
from point \code{y} (proceeding downward).}

\item{rx, ry}{Optional corner radius values in the 'x' and 'y' directions.
Applies to all corners of the rectangle. If only one value is provided
(say, just for \code{rx}) then the unset value will take that set value as well.}

\item{stroke}{The color of the stroke applied to the element (i.e., the
outline).}

\item{stroke_width}{The width of the stroke in units of pixels.}

\item{fill}{The fill color of the element.}

\item{opacity}{The opacity of the element. Must be a value in the
range of \code{0} to \code{1}.}

\item{attrs}{A presentation attribute list. The helper function
\code{\link[=svg_attrs_pres]{svg_attrs_pres()}} can help us easily generate this named list object. For the
most part, the list's names are the presentation attribute names and the
corresponding values are the matching attribute values.}

\item{anims}{An animation directive list for the element. This should be
structured using the \code{\link[=anims]{anims()}} function.}

\item{filters}{A filter directive list for the element. This is easily
created by using a list of \verb{filter_*()} functions (e.g.,
\code{list(filter_gaussian_blur(2), filter_drop_shadow(2, 2))}).}

\item{id}{An optional ID value to give to the built tag. This is useful for
modifying this element in a later function call or for interacting with
CSS.}
}
\value{
An \code{svg} object.
}
\description{
The \code{svg_rect()} function adds a rectangle to an \code{svg} object. The position
of the rectangle is given by \code{x} and \code{y}, and this refers to the upper left
point of the rectangle. The \code{width} and the \code{height} are the dimensions of
the rectangle. All of these dimensions are in units of \code{px}. The optional
\code{rx} and \code{ry} parameter are corner radius values (again, in \code{px} units) that
define x and y radius of the corners of the rectangle.
}
\examples{
if (interactive()) {

# Create an SVG with a single
# rectangle element
svg_1 <-
  SVG(width = 100, height = 100) \%>\%
    svg_rect(
      x = 20, y = 10,
      width = 40, height = 15,
      stroke = "blue", fill = "yellow"
    )

# Create an SVG with a single
# rectangle element that moves
# to new `x` positions
svg_2 <-
  SVG(width = 300, height = 300) \%>\%
    svg_rect(
      x = 50, y = 50,
      width = 50, height = 50,
      stroke = "magenta", fill = "lightblue",
      anims = anims(
        0.5 ~ list(
          anim_position(
            x = 50, y = 50,
            easing_fn = ease_out()
          ),
          anim_rotation(rotation = 0)
        ),
        2.0 ~ list(
          anim_position(
            x = 200, y = 50,
            easing_fn = ease_in_out()
          ),
          anim_rotation(rotation = 90)
        )
      )
    )
}

}
