% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_planning_areas.R
\name{get_planning_areas}
\alias{get_planning_areas}
\title{Get Planning Areas (All)}
\usage{
get_planning_areas(token, year = NULL, return_spatial = FALSE)
}
\arguments{
\item{token}{User's API token. This can be retrieved using \code{\link{get_token}}}

\item{year}{Optional, check \href{https://www.onemap.gov.sg/docs/#planning-area-polygons}{documentation} for valid options. Invalid requests will are ignored by the API.}

\item{return_spatial}{Optional, whether to return the result as a \code{sf} tibble instead of JSON object. Default value is \code{FALSE}}
}
\value{
If the parameter \code{read} is not specified, the function returns a raw JSON object with planning names and geojson string vectors. \cr \cr
If \code{return_spatial = TRUE}, the function returns a single "sf" tibble with 2 columns: "name" (name of planning area) and "geometry", which contains the simple features. \cr \cr
If an error occurs, the function throws an error with the API error message and status code.
}
\description{
This function is a wrapper for the \href{https://www.onemap.gov.sg/docs/#planning-area-polygons}{Planning Area Polygons API}. It returns the data either in raw format or a combined sf object.
}
\note{
If the user specifies \code{return_spatial = TRUE}  but does not have the \code{sf} package installed, the function will return the raw JSON and print a warning message.
}
\examples{
# returns raw JSON object
\dontrun{get_planning_areas(token)}
\dontrun{get_planning_areas(token, 2008)}

# returns dataframe of class "sf"
\dontrun{get_planning_areas(token, return_spatial=TRUE)}

# error: output is NULL, warning message shows status code
\dontrun{get_planning_areas("invalid_token")}
}
