% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_planning_polygon.R
\name{get_planning_polygon}
\alias{get_planning_polygon}
\title{Get Planning Polygon for a Specific Point}
\usage{
get_planning_polygon(token, lat, lon, year = NULL, return_spatial = FALSE)
}
\arguments{
\item{token}{User's API token. This can be retrieved using \code{\link{get_token}}}

\item{lat}{Latitude of location point}

\item{lon}{Longitude of location point}

\item{year}{Optional, check \href{https://www.onemap.gov.sg/docs/#planning-area-query}{documentation} for valid options. Invalid requests will are ignored by the API.}

\item{return_spatial}{Optional, defaults to \code{FALSE}. If \code{TRUE}, result will be returned as a \code{sf} tibble, otherwise the raw JSON object will be returned.}
}
\value{
If the parameter \code{read} is not specified, the function returns a raw JSON object a list containing the planning area name and a geojson string representing the polygon. \cr \cr
If \code{read = "sf"}, the function returns a 1 x 2 "sf" dataframe: "name" (name of planning area) and "geometry", which contains the simple feature. \cr \cr
If an error occurs, the function throws an error with the API error message and status code.
}
\description{
This function is a wrapper for the \href{https://www.onemap.gov.sg/apidocs/planningarea/#planningAreaPolygon}{Planning Area Query API}. It returns the spatial polygon data matching the specified location point, either in raw format or as an sf tibble.
}
\note{
If the user specifies a \code{return_spatial = TRUE} but does not have the \code{sf} package installed, the function will return the raw JSON and print a warning message.
}
\examples{
# returns raw JSON object
\dontrun{get_planning_polygon(token, lat = 1.429443081, lon = 103.835005)}
\dontrun{get_planning_polygon(token, lat = 1.429443081, lon = 103.835005, year = 2008)}

# returns dataframe of class "sf"
\dontrun{get_planning_polygon(token, lat = 1.429443081, lon = 103.835005, return_spatial = TRUE)}

# error: output is NULL, warning message shows status code
\dontrun{get_planning_polygon("invalid_token", lat = 1.429443081, lon = 103.835005)}
\dontrun{get_planning_polygon(token, "invalidlat", "invalidlon")}
}
