% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_theme_status.R
\name{get_theme_status}
\alias{get_theme_status}
\title{Check Theme Status}
\usage{
get_theme_status(
  token,
  theme,
  date = Sys.Date(),
  time = format(Sys.time(), format = "\%T")
)
}
\arguments{
\item{token}{User's API token. This can be retrieved using \code{\link{get_token}}}

\item{theme}{Query name of theme. Themes’ query names can be retrieved using \code{\link{search_themes}}.}

\item{date}{Default = current date. Date to check for updates. Format YYYY-MM-DD}

\item{time}{Default = current time. Time to check for updates. Format: HH:MM:SS:FFFZ}
}
\value{
A named logical indicating if the theme is updated at a specific date.
If an error occurred, the function throws an error with the status code and API's error message.
}
\description{
This function is a wrapper for the \href{https://www.onemap.gov.sg/apidocs/themes/#checkThemeStatus}{Check Theme Status API}. It returns a named logical indicating if the theme is updated at a specific date.
}
\examples{
# returns named logical
\dontrun{get_theme_status(token, "kindergartens")}
\dontrun{get_theme_status(token, "hotels", "2020-01-01", "12:00:00")}

# throws an error with error message and status code
\dontrun{get_theme_status("invalid_token", "blood_bank")}

# throws an error with error message and status code
\dontrun{get_theme_status(token, "invalid_theme")}
}
