% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_key.R
\name{set_api_key}
\alias{set_api_key}
\alias{get_api_key}
\title{Get and set your openFDA API keys}
\usage{
set_api_key(api_key)

get_api_key()
}
\arguments{
\item{api_key}{A single-length character vector with your openFDA API key.
You can generate an API key on the
\href{https://open.fda.gov/apis/authentication/}{FDA website}.}
}
\value{
A single length character vector with your API key. For
\code{set_api_key()}, this is returned invisibly.

For \code{get_api_key()}, an error will be thrown if no key has been set.
}
\description{
Get and set your openFDA API keys
}
\note{
To permanently set the API key for a given project, set \code{OPENFDA_TOKEN}
in \code{.Renviron}.
}
\examples{
# Set your openFDA API key with `set_api_key()`
api_key <- "example_api_key"
set_api_key(api_key)

# Retrieve it with `get_api_key()`
get_api_key()

# An error will be thrown if your API key is an empty string.
set_api_key("")

try(get_api_key())
}
