% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_fine_tune.R
\name{create_fine_tune}
\alias{create_fine_tune}
\title{Create fine-tune}
\usage{
create_fine_tune(
  training_file,
  validation_file = NULL,
  model,
  n_epochs = 4,
  batch_size = NULL,
  learning_rate_multiplier = NULL,
  prompt_loss_weight = 0.1,
  compute_classification_metrics = FALSE,
  classification_n_classes = NULL,
  classification_positive_class = NULL,
  classification_betas = NULL,
  suffix = NULL,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{training_file}{required; a length one character vector.}

\item{validation_file}{optional; defaults to \code{NULL}; a length one character
vector.}

\item{model}{required; a length one character vector.}

\item{n_epochs}{required; defaults to \code{4}; a length one numeric vector with
the integer value greater than \code{0}.}

\item{batch_size}{optional; defaults to \code{NULL}; a length one numeric vector
with the integer value greater than \code{0}.}

\item{learning_rate_multiplier}{optional; defaults to \code{NULL}; a length one
numeric vector with the value greater than \code{0}.}

\item{prompt_loss_weight}{required; defaults to \code{0.1}; a length one numeric
vector.}

\item{compute_classification_metrics}{required; defaults to \code{FLASE}; a length
one logical vector.}

\item{classification_n_classes}{optional; defaults to \code{NULL}; a length one
numeric vector with the value greater than \code{0}.}

\item{classification_positive_class}{optional; defaults to \code{NULL}; a length
one character vector.}

\item{classification_betas}{optional; defaults to \code{NULL}; a list elements of
which are numeric values greater than \code{0}.}

\item{suffix}{optional; defaults to \code{NULL}; a length one character vector.}

\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, elements of which contain information about the
fine-tune.
}
\description{
Creates a job that fine-tunes a specified model based on a given dataset. See
\href{https://platform.openai.com/docs/api-reference/fine-tunes/create}{this page} for
details.
}
\details{
For arguments description please refer to the \href{https://platform.openai.com/docs/api-reference/fine-tunes/create}{official documentation}.
}
\examples{
\dontrun{
training_file <- system.file(
    "extdata", "sport_prepared_train.jsonl", package = "openai"
)
validation_file <- system.file(
    "extdata", "sport_prepared_train.jsonl", package = "openai"
)

training_info <- upload_file(training_file, "fine-tune")
validation_info <- upload_file(validation_file, "fine-tune")

info <- create_fine_tune(
    training_file = training_info$id,
    validation_file = validation_info$id,
    model = "ada",
    compute_classification_metrics = TRUE,
    classification_positive_class = " baseball" # Mind space in front
)
}
}
\seealso{
Other fine-tune functions: 
\code{\link{cancel_fine_tune}()},
\code{\link{delete_fine_tune_model}()},
\code{\link{list_fine_tune_events}()},
\code{\link{list_fine_tunes}()},
\code{\link{retrieve_fine_tune}()}
}
\concept{fine-tune functions}
