% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/API-Remote.R
\name{use_OpenMpp_remote}
\alias{use_OpenMpp_remote}
\title{OpenM++ Remote API Connection}
\usage{
use_OpenMpp_remote(
  url = Sys.getenv("OPENMPP_REMOTE_URL"),
  user = Sys.getenv("OPENMPP_REMOTE_USER"),
  pwd = Sys.getenv("OPENMPP_REMOTE_PWD"),
  ...
)
}
\arguments{
\item{url}{URL for making API requests. See \code{Details} for more
instructions.}

\item{user}{User name for logging into remote API. See \code{Details} for more
instructions.}

\item{pwd}{Password for logging into remote API. See \code{Details} for more
instructions.}

\item{...}{Not currently used.}
}
\value{
Nothing, invisibly. Behind-the-scenes, an instance of the
\code{OpenMppRemote} R6 class is created. These objects should not be accessed
directly by the user, instead, the package internally uses these
connections to communicate with the OpenM++ API.
}
\description{
Register a connection to the OpenM++ Web Services (OMS) Application
Programming Interface (API). Currently, two different API connections
"local" and "remote" are available. Note that "local" and "remote"
describe where the API is running relative to the machine running the R
session. Those who use a machine running on their local network may use
a remote connection to connect with a cloud-based API, for example.
Users running OpenM++ locally or who are logged into a remote virtual
machine running OpenM++ will use the local API connection.
}
\details{
A \code{user} name and password (\code{pwd}) are sensitive information and
should not be shared. To avoid hard-coding your user name and password into
your R scripts, we recommend declaring this information in your global or
project-specific \code{.Renviron} file. The same approach may be used to declare
your URLs for making API requests. While these URLs are typically not
sensitive information, keeping all of this information in one place makes
sense for consistency. For remote API connections, set the
following environment variables in your \code{.Renviron} files:
\itemize{
\item \code{OPENMPP_REMOTE_URL}: URL for a remote API connection.
\item \code{OPENMPP_REMOTE_USER}: User name for logging into a remote API
connection.
\item \code{OPENMPP_REMOTE_PWD}: Password for logging into a remote API connection.
}
}
\examples{
\dontrun{
use_OpenMpp_remote()
}

}
