% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_funs.R
\name{total_cost}
\alias{total_cost}
\title{Compute direct total cost to raise hatchery fish}
\usage{
total_cost(
  time,
  time_slope = 1,
  time_exp = 1,
  init_cost = 0,
  recruits = 1,
  rec_exp = 1
)
}
\arguments{
\item{time}{The amount of time that fish are raised in hatchery}

\item{time_slope}{Controls how quickly the slope increases over time}

\item{time_exp}{Controls the non-linearity of the curve over time}

\item{init_cost}{The initial cost (i.e. intercept of the curve)}

\item{recruits}{The number of recruits}

\item{rec_exp}{Controls the non-linearity of the curve across recruit number}
}
\value{
A vector of values representing cost for the given time, recruit
number, and associated variables
}
\description{
This function computes the total cost to raise fish in a hatchery until
\code{time}. This function differs from \code{\link{total_daily_cost}} by
directly computing the total cost rather than integrating a daily cost
estimate.
}
\details{
The \code{total_cost} function computes a cost curve according to the
following equation:

\ifelse{html}{
 \out{<i>C = s<sub>T</sub>t<sup>&alpha;</sup>
      * s<sub>2</sub>R<sup>&beta;</sup> + b</i>}}{
 \deqn{C = \alpha * T ^ \gamma + \beta + R^\tau}
}

where \ifelse{html}{\out{&alpha;}}{\eqn{\alpha}} corresponds to the
\code{time_slope} argument,
\ifelse{html}{\out{&gamma;}}{\eqn{\gamma}} is the \code{time_exp} parameter,
\ifelse{html}{\out{&beta;}}{\eqn{\beta}} is the intercept (or
\code{init_cost}),
R is the number of recruits, and
\ifelse{html}{\out{&tau;}}{\eqn{\tau}} is the recruitment exponent
corresponding to \code{rec_exp}
}
\examples{
curve(total_cost(x, time_slope = 0.05, time_exp = 1.2), 0, 100)
curve(total_cost(x, time_slope = 0.05, time_exp = 0.5), 0, 100)
}
