% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InfinitySparseMatrix.R
\docType{class}
\name{BlockedInfinitySparseMatrix-class}
\alias{BlockedInfinitySparseMatrix-class}
\title{Blocked Infinity Sparse Matrix}
\description{
Blocked Infinity Sparse Matrices are similar to Infinity Sparse Matrices, but they also keep track of the groups of units via an additional slot, \code{groups}
}
\section{Slots}{

\describe{
\item{\code{groups}}{factor vector containing groups, with unit names as labels, when possible}

\item{\code{colnames}}{vector containing names for all control units. This will either be a character vector or NULL if units have no names}

\item{\code{rownames}}{vector containing names for all treated units. This will either be a character vector or NULL if units have no names}

\item{\code{cols}}{vector of integers corresponding to control units}

\item{\code{rows}}{vector of integers corresponding to treated units}

\item{\code{dimension}}{integer vector containing the number of treated and control units, in that order}

\item{\code{call}}{function call used to create the \code{InfinitySparseMatrix}}
}}

\seealso{
\code{\link{match_on}}, \code{\link{exactMatch}}, \code{\link{fullmatch}},  \code{\link{InfinitySparseMatrix-class}}
}
\author{
Mark M. Fredrickson
}
