% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_path.R
\name{find_all_paths}
\alias{find_all_paths}
\title{Find all paths between two nodes}
\usage{
find_all_paths(graph, from, to)
}
\arguments{
\item{graph}{A graph object}

\item{from}{The starting node of the path}

\item{to}{The ending node of the path}
}
\value{
A list of character vectors
}
\description{
Find all the paths between two nodes in a graph.

Not all graphs support this function. Currently only
\code{DirectedAcyclicGraph} supports this.
}
\examples{
graph <- graph_builder() |>
  add_path(c("A", "B", "C")) |>
  add_path(c("A", "Z", "C")) |>
  add_path(c("A", "B", "A")) |>
  build_directed()

find_all_paths(graph, "A", "C")
}
\seealso{
Other analyze graphs: 
\code{\link{find_path}()},
\code{\link{find_path_one_to_many}()},
\code{\link{get_all_leaves}()},
\code{\link{get_all_roots}()},
\code{\link{get_leaves_under}()},
\code{\link{get_roots_over}()},
\code{\link{least_common_parents}()}
}
\concept{analyze graphs}
