% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crmsimulations.R
\name{crmsimulations}
\alias{crmsimulations}
\title{Simulations to Assess operating characteristics of proportional odds model (POM), continuation ratio (CR) Model, and binary CRM Designs}
\usage{
crmsimulations(startdose, numbersims, cohortsize = 3, samplesize = 30,
  pseudoweights = NA, stopearly = FALSE, stopearlynumber = NA, pseudotox,
  pseudodose, dosetox, truedosetoxmodeltype, design, targetDLT = 0.3,
  discrete = FALSE, discretedoses = NA, numberdltrule = NA,
  lowerlimitrule = NA, upperlimitrule = NA, dltrule = NA,
  increaserule = NA, minimum = NA, maximum = NA, combine01 = FALSE,
  rounddown = FALSE)
}
\arguments{
\item{startdose}{Starting dose for a trial for a specified target DLT rate.}

\item{numbersims}{Number of simulations you wish to run (We used 2000 simulations in our studies).}

\item{cohortsize}{Number of patients treated in each cohort. Defaults to 3.}

\item{samplesize}{Total sample size of each trial. Defaults to 30.}

\item{pseudoweights}{Pseudoweights determine the amount of influence the pseudodata has on estimating the updated model.
Please refer to Van Meter et al (2010) for more information. We suggest setting the pseudoweights equal to the cohortsize.
When pseudoweights = X, the total pseudodata represent X individuals in the updated model. If not specified,
pseudoweights defaults to cohortsize.}

\item{stopearly}{True/False. Allows early stopping if a certain number of patients are treated at the same dose level and
the model estimates the same dose to treat the next cohort.
Must specify stopearlynumber when stopearly = TRUE. Defaults to FALSE.}

\item{stopearlynumber}{Total number of patients treated at the same dose level before stopping.
Must set stopearly = TRUE when a number is specified.}

\item{pseudotox}{A vector of toxicity grades specified by the pseudodata.}

\item{pseudodose}{A vector of dose levels specified by the pseudodata.}

\item{dosetox}{Specifies the true underlying dose-toxicity relationship model. Please refer to
Van Meter et al (2010) for specification of the POM and CR model.
Assumes 5 toxicity categories as specified by CTCAEv4.0, i.e. grades 0, 1, 2,
3, and 4. Grade 5 toxicities (death directly related to an adverse event are not considered when running simulations).\cr
If using a POM, it must be in the form:
 c(\eqn{\alpha1, \beta1, \alpha2, \beta2, \alpha3, \beta3, \alpha4, \beta4}).\cr
If using a CR model it must be in the form: c(\eqn{\alpha, \gamma0, \theta1,
\gamma1, \theta2, \gamma2, \theta3, \gamma3}).
\strong{IMPORTANT!} If combine01 is true, you still must specify the dosetox model in
terms of grades 0, 1, 2, 3, and 4 for the simulations to run correctly!!!}

\item{truedosetoxmodeltype}{Must specify what type of true underlying dose-toxicity model you are using.
Choices are: POM, CR, or CRM.}

\item{design}{Specifies which dose finding design you are running simulations on. Choices are: POM, CR, or CRM.}

\item{targetDLT}{Target dose limiting toxicity (DLT) rate pre-specified by clinical investigators prior to the start of the trial.
Must be specified between 0 and 1. Defaults to 0.30.}

\item{discrete}{True/False. If discrete = TRUE this allows for discrete dose levels
to be specified prior to the start of the trial. Defaults to FALSE}

\item{discretedoses}{Specified discrete dose levels if desired. They must be specified if discrete is equal to TRUE.
It is written for j dose levels as: c(d1, d2,..., dj).}

\item{numberdltrule}{Number of dose limiting toxicities (DLTs) that would be considered excessively unsafe if observed in a cohort of patients.
This would prompt the DLT constraint if there is one specified. Defaults to NA.}

\item{lowerlimitrule}{If lowerlimitrule is specified, this constraint will stop the trial if the dose
is estimated to be under a certain level as a safety precaution. Investigators may feel any dose under
this lowerlimitrule would suggest excessive toxicity with this investigational drug and no true MTD may exist.\cr
This can be specified as a dose level or percentage.\cr
If lowerlimitrule <1 (percentage), it takes the range of possible data (maximum - minimum) and makes the lower bound
when the trial would stop early as: minimum + (maximum - minimum)*lowerlimitrule.\cr
If lowerlimitrule >1 (dose level) then the lower bound when the trial would stop early is the lowerlimitrule.}

\item{upperlimitrule}{If upperlimitrule is specified, this constraint will stop the trial if the dose is estimated to be higher
than a certain level. \cr
If upperlimitrule <1 (percentage), it takes the range of possible data (maximum - minimum) and makes the upper bound
when the trial would stop early as: maximum - (maximum - minimum)*upperlimitrule. \cr
If upperlimitrule >1 (dose level) then the upper bound
when the trial would stop early is the upperlimitrule.}

\item{dltrule}{If the numberdltrule (i.e. 2 DLTs) occurs in the last cohort of patients tested,
the next estimated dose must decrease by an amount specified by the dltrule.
Defaults to NA.  \cr
If 0 < dltrule < 1 (percentage), with excessive DLTs in the last cohort,
the next estimated dose must decrease by the dltrule (percentage) of
the last tested dose level, i.e. (1-dltrule)*lastdose.\cr
If dltrule >= 1 (dose level), with excessive DLTs in the last cohort
the next estimated dose must decrease by dltrule dose level, i.e. lastdose-dltrule.}

\item{increaserule}{If increaserule is specified, then the next estimated dose
can only increase by an amount specified by the increaserule between tested cohorts. Defaults to NA.\cr
If 0 < increaserule < 1 (percentage), the next dose can only increase to a maximum of lastdose*(1+increaserule).\cr
If increaserule >= 1 (dose level), the next dose can only increase to a maximum of lastdose + increaserule.}

\item{minimum}{Minimum dose that will be considered to test patients. Must be specified if lowerlimitrule<1.}

\item{maximum}{Maximum dose that will be considered to test patients. Must be specified if upperlimitrule<1.}

\item{combine01}{True/False. If combine01 = TRUE, toxicity grades 0 and 1 are combined into 1 category.
Therefore all toxicities must be coded: 0 (grades 0 and 1), 1 (grade2), 2 (grade 3),
and 3 (grade 4) according to CTCAEv4.0. Defaults to FALSE.}

\item{rounddown}{True/False. Only applicable when using discrete dose levels.\cr
If rounddown = TRUE, the estimate dose from specified model will round down to the more conservative discrete dose level.\cr
If rounddown = FALSE, it will select the discrete dose closest to the estimated model selection. Defaults to FALSE.}
}
\value{
Returns various safety and dose estimation performance statistics collected over all simulations.
Please see the list below for details.

\item{`Median Total Sample Size of Trials Not Stopped Early Due to Safety Concerns`}{Median
total sample size of trial for all simulations not stopped early due to ANY safety constraints.}

\item{`Patients per Cohort`}{Pre-defined cohortsize}

\item{`Proportion of Trials Stopped Early Due to Safety Concerns`}{Proportion of trials
stopped early due to ANY safety constraints among all simulations.}

\item{`Proportion of Trials Stopped Early Used Constraint`}{Proportion of trials stopped
early due to any constraints while estimating the final dose for all simulations.}

\item{`Proportion of Trials Stopped Early Used the DLT Constraint`}{Proportion of trials
stopped early only due to the DLT constraint while estimating the final dose for all simulations.}

\item{`Proportion of Trials Stopped Early Used the Increase Constraint`}{Proportion of trials
stopped early only due to the increase constraint while estimating the final dose for all simulations.}

\item{`25\% Quantile Sample Size`}{25\% quantile total Sample Size of trial for all simulations.}

\item{`75\% Quantile Sample Size`}{75\% quantile total Sample Size of trial for all simulations.}

\item{`Median Dose`}{Median dose estimated from all simulations.}

\item{`25\% Quantile Dose`}{25\% quantile dose estimated from all simulations.}

\item{`75\% Quantile Dose`}{75\% quantile dose estimated from all simulations.}

\item{`Percentage of Times Each Discrete Dose Level Was Selected`}{This value is only returned when "discrete" is TRUE and
"discretedoses" are pre-specified. Each discrete dose level has a percentage indicating the chance that the dose level
been selected as the final estimated dose for all simulations.}

\item{`Median Percent Difference Between Estimated Dose and MTD`}{Median difference in percentage between the final
estimated dose and the true maximum tolerated dose (MTD) for all simulations.}

\item{`Median Expected DLT for the Final Estimated Dose`}{Median expected DLT rate
for the final estimated dose for all simulations.}

\item{`Median Sample Size For All Trials`}{Median total sample size of trial for all simulations.}

\item{`Median \% of patients in all trials treated at doses with >40\% DLT rate`}{Median percentage of patients
in the trial treated at doses with a DLT rate larger than 40\% for all simulations.}

\item{`Median \% of patients in all trials treated at doses with >50\% DLT rate`}{Median percentage of patients
in the trial treated at doses with a DLT rate larger than 50\% for all simulations.}

\item{`Median \% of patients in all trials treated at doses with <20\% DLT rate`}{Median percentage of patients
in the trial treated at doses with a DLT rate less than 20\% for all simulations.}

\item{`Median \% of patients in all trials treated at doses with <10\% DLT rate`}{Median percentage of patients
in the trial treated at doses with a DLT rate less than 10\% for all simulations.}

\item{`Median Number of patients in all trials with a DLT (grade 3 or 4)`}{Median number of patients
in trial with a grade 3 or grade 4 DLT for all simulations.}

\item{`Median \% of patients in all trials with a DLT (grade 3 or 4)`}{Median percentage of patients
in trial with a grade 3 or grade 4 DLT for all simulations.}

\item{`Median \% of patients in all trials with grade 0 and 1`}{Median percentage of patients
in trial with a grade 1 or grade 2 DLT for all simulations.}

\item{`Median \% of patients in all trials with a non-DLT (grade 1 or 2)`}{Median percentage of patients
in trial with a grade 1 or grade 2 non-DLT for all simulations.}

\item{`Median \% of patients in all trials with no toxicity`}{Median percentage of patients
in trial without DLT for all simulations.}

\item{`Median \% of patients in all trials with grade 1`}{Median percentage of patients
in trial with grade 1 DLT for all simulations.}

\item{`Median \% of patients in all trials with grade 2`}{Median percentage of patients
in trial with grade 2 DLT for all simulations.}

\item{`Median \% of patients in all trials with grade 3`}{Median percentage of patients
in trial with grade 3 DLT for all simulations.}

\item{`Median \% of patients in all trials with grade 4`}{Median percentage of patients
in trial with grade 4 DLT for all simulations.}

\item{`Acutal MTD`}{True MTD specified from dosetox.}

\item{`True MTD Discrete`}{This value is only returned when "discrete" is TRUE and
"discretedoses" are pre-specified. Rounds the "Acutal MTD" to the nearest pre-specified discrete dose.}

\item{Dose}{A vector of final estimated dose from each simulation.}

\item{Listit}{A matrix of estimated doses after each cohort for each simulation.
For example, if "numbersims" is 5 and there are 10 cohorts in each trial, this will result in a 5*10 matrix.}
}
\description{
This function performs simulations to assess design performance characteristics of the proportional odds model (POM),
continuation ratio (CR) Model, and binary CRM likelihood-based dose finding designs.
There are many different options in this function
to vary sample size, cohort sizes, target dose-limiting toxicity (DLT) rates, true underlying dose-toxicity models,
discrete or continuous dose levels, combining ordianl grades 0 and 1 into one category, and the design you wish to assess.
Returns results collected over all simulations run for these specified safety and dose estimation performance criteria.
}
\details{
If using a POM CRM, this function assumes a proportional odds model as described by Harrell (Harrell, 2001).
For combine01=FALSE, y equal to toxicity grade outcomes j in c(0, 1, 2, 3, 4) as specified by CTCAEv4.0, and x equal to the dose,
this is written in the form:\cr
\deqn{P(y>=j|x)=1/(1+exp(-(\alpha_j + \beta*x))), j = 1, 2, 3, 4}\cr
For combine01=TRUE, toxicity grades are now 0/1, 2, 3, and 4, and y is recoded as 0 = grades 0 and 1, 1 = grade 2,
2 = grade 3, and 3 = grade 4.\cr

If using a CR model design, this function assumes a continuation ratio model as described by Harrell (Harrell, 2001).
For combine01=FALSE, y equal to toxicity grade outcomes j in c(0, 1, 2, 3, 4) as specified by CTCAEv4.0, and x equal to the dose,
this is written in the form:\cr
\deqn{P(y=j|y>=j,x)=1/(1+exp(-(\alpha + \theta_j + \gamma*x))), j = 0, 1, 2, 3}\cr
For combine01=TRUE, toxicity grades are now 0/1, 2, 3, and 4, and y is recoded as 0 = grades 0 and 1, 1 = grade 2,
2 = grade 3, and 3 = grade 4.\cr

If using a binary CRM, this assumes a standard 2-parameter logistic model.
For y equal to toxicity outcome (1 is a DLT, 0 is not a DLT) and x equal to the dose, it is written in the form:\cr
\deqn{P(y=1|x)=1/(1+exp(-(\alpha + \beta*x)))}\cr

Estimated next dose is calculated by Pr(3 or 4 toxicity) <= targetDLT for the model utilized.
}
\examples{
#Example 1
#Underlying True POM dosetox
truePO1<-c(-0.4, 0.0011, -1.3, 0.0011, -2.8, 0.0011, -3.9, 0.0011)
#POM Pseudodata
initial.pom.y1<-c(rep(0,45),rep(1,36),rep(2,9),rep(3,8),rep(4,2),rep(0,18),
rep(1,35),rep(2,17),rep(3,24),rep(4,6),rep(0,8),rep(1,24),rep(2,18),rep(3,38),
rep(4,12),rep(0,1),rep(1,4),rep(2,5),rep(3,35),rep(4,55))
initial.pom.d1<-c(rep(200,100),rep(1067,100),rep(1613,100),rep(3000,100))
#POM CRM Design Simulation run 10 times, with a true dosetox model equal to a POM
crmsimulations(startdose = 1060, numbersims = 10, cohortsize = 3, samplesize = 30,
pseudoweights = 3,pseudotox = initial.pom.y1, pseudodose = initial.pom.d1, dosetox = truePO1,
truedosetoxmodeltype = 'POM', design = 'POM', targetDLT = 0.30, discrete = FALSE,
discretedoses = NA, numberdltrule = NA, lowerlimitrule = NA, upperlimitrule = NA,
dltrule = NA, increaserule= NA, minimum = NA, maximum = NA, combine01 = FALSE)

#Example 2
#Underlying true POM dosetox
truePO1<-c(-0.4, 0.0011, -1.3, 0.0011, -2.8, 0.0011, -3.9, 0.0011) #POM 1#
#CR Model Pseudodata with Grades 0 and 1 combined into one category
combine.cr.y1<-c(rep(0,81),rep(1,9),rep(2,8),rep(3,2),
rep(0,55),rep(1,15),rep(2,26),rep(3,4),
rep(0,37),rep(1,13),rep(2,40),rep(3,10),
rep(0,5),rep(1,5),rep(2,35),rep(3,55))
initial.cr.d1<-c(rep(200,100),rep(934,100),rep(1467,100),rep(3000,100))
#CR Model CRM Design Simulation run 10 times, with a true dosetox model equal to a POM
crmsimulations(startdose = 1060, numbersims = 10, cohortsize = 3,
samplesize = 30, pseudoweights = 3,pseudotox = combine.cr.y1,
pseudodose = initial.cr.d1, dosetox = truePO1, truedosetoxmodeltype = 'POM',
design = 'CR', targetDLT = 0.30, discrete = FALSE, discretedoses = NA,
numberdltrule = NA, lowerlimitrule = NA, upperlimitrule = NA, dltrule = NA,
increaserule = NA, minimum = NA, maximum = NA, combine01 = TRUE)

#Example 3
#Underlying True CR dosetox
crmodel1<-c(1.58,-0.0018,-0.45,-0.0018,1.20,-0.0018,3.14,-0.0018) #CR Model 1#
#CRM Pseudodata
initial.crm.y1<-c(rep(0,90),rep(1,10),rep(0,70),rep(1,30),
rep(0,50),rep(1,50),rep(0,10),rep(1,90))
initial.crm.d1<-c(rep(200,100),rep(1060,100),rep(1600,100),rep(3000,100))
#Binary CRM Design Simulation run 10 times, with a true dosetox model equal to a CR
crmsimulations(startdose = 1060, numbersims = 10, cohortsize = 2,
samplesize = 20, pseudoweights = 3,pseudotox = initial.crm.y1,
pseudodose = initial.crm.d1, dosetox = crmodel1, truedosetoxmodeltype = 'CR',
design = 'CRM', targetDLT = 0.30, discrete=TRUE,
discretedoses=c(200,400,800,1200,1800,2500),
numberdltrule = NA, lowerlimitrule = NA, upperlimitrule = NA, dltrule = NA,
increaserule = NA, minimum = NA, maximum = NA, combine01 = FALSE)

}
\author{
Emily V. Dressler, PhD \cr
Markey Cancer Center \cr
Division of Cancer Biostatistics \cr
University of Kentucky \cr
\email{EmilyVDressler@gmail.com}
}
\references{
1. Van Meter EM, Garrett-Mayer E, Bandyopadhyay D. Proportional odds model for dose finding clinical trial designs with ordinal toxicity grading. Statistics in Medicine 2011; 30: 2070-2080. \cr
2. Van Meter EM, Garrett-Mayer E, Bandyopadhyay. Dose finding clinical trial design for ordinal toxicity grades using the continuation ratio model: an extension of the continual reassessment method. Clinical Trials 2012; 9(3): 303-313. \cr
3. Garrett-Mayer E. The continual reassessment method for dose-finding studies: a tutorial. Clinical Trials 2006; 3: 57-71. \cr
4. Piantadosi S, Fisher JD, Grossman S. Practical implementation of a modified continual reassessment method for dose-finding trials. Cancer Chemother Pharmacol 1998; 41: 429-436. \cr
5. Harrell FE, Jr. Regression Modeling Strategies with Application to Linear Models, Logistic Regression, and Survival Analysis. Springer: New York, NY, 2001. \cr
6. McCullagh P. Regression Models for Ordinal Data. Journal of the Royal Statistical Society. Series B (Methodological). 1980; 42: 109-142. \cr
7. CTCAE. Cancer Therapy Evaluation Program, Common Terminology Criteria for Adverse Events, Version 4.0, DCTD, NCI, NIH, DHHS (http://ctep/cancer.gov). In Cancer Therapy Evaluation Program, 2010.
}

