% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinalCont.R
\docType{data}
\name{neck_pain}
\alias{neck_pain}
\title{Neck pain data set}
\format{
A data frame with 264 rows and 4 variables
}
\usage{
data(neck_pain)
}
\description{
A subset from an Australian chronic neck pain study
}
\details{
A randomized, double-blind, placebo-controlled study of low-level laser therapy (LLLT) in 88 
subjects with chronic neck pain was conducted with the aim of determining the efficacy of 300 mW, 
830 nm laser in the management of chronic neck pain. Subjects were randomized to receive a course of 
14 treatments over 7 weeks with either active or sham laser to tender areas in the neck. The primary 
outcome measure was change in a 10 cm Visual Analogue Scale (VAS) for pain.
Measurements were taken at baseline, at the end of 7 weeks\' treatment and 12 weeks from baseline.

The variables are as follows:

\tabular{ll}{
\code{id}\tab patient ID number\cr
\code{vas}\tab Neck pain as recorded by the patient on a VAS scale,  normalized to (0, 1)\cr
\code{laser}\tab laser treatment received by  patient, either 1 (active) or 2 (placebo)\cr
\code{time}\tab the measurement time, either 1 (initial assessment), 2 (after 7 weeks) or 3 (after 12 weeks). \cr
}
}
\references{
Chow RT, Heller GZ, Barnsley L (2006). ``The effect of 300 mW, 830 nm laser on chronic 
neck pain: a double-blind, randomized, placebo-controlled study.'' Pain, 124(1-2), 201-10. doi:16806710.
}
\concept{datasets}
