% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clayton.R
\name{Clayton_marginal_location}
\alias{Clayton_marginal_location}
\title{Fits the tests comparing locations of the margins of a two-way table.}
\usage{
Clayton_marginal_location(wx, wy)
}
\arguments{
\item{wx}{vector containing frequencies for the first margin of the table}

\item{wy}{vector containing frequencies for the second margin of the table}
}
\value{
a list of results
   odds_ratios: odds ratios comparing cumulative frequencies of adjacent categories
   log_theta_hat: log of estimate of the common odds-ratio
   theta_hat: estimate of the common odds-ratio
   log_mh_theta_hat: log of the Mantel-Haenssel type odds-ratio
   mh_theta_hat: Mantel-Haenszel type odds-ratio
   var_log_theta_hat = variance of the log of the odds-ratios
   chisq_theta_hat: chi-square for odds-ratio
   chisq_mh_theta_hat: chi-square for Mantel-Haenszel odds-ratio
   df: degrees of freedom for chis-square = 1
}
\description{
The measure is based on the weighted cdfs. No "scores" are used, just the
weighted (cumulative sums).
Clayton, D. G. (1974) Odds ratio statistics for the analysis of ordered categorical data.
Biometrika, 61(3), 525-531.
}
\examples{
Clayton_marginal_location(tonsils[1,], tonsils[2,])
}
