% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Goodman_association.R
\name{Goodman_model_ii}
\alias{Goodman_model_ii}
\title{Fits Goodman's (1979) Model II}
\usage{
Goodman_model_ii(
  n,
  rho = 1:nrow(n) - (nrow(n) + 1)/2,
  sigma = 1:ncol(n) - (ncol(n) + 1)/2,
  update_rows = TRUE,
  update_columns = TRUE,
  max_iter = 25,
  verbose = FALSE,
  exclude_diagonal = FALSE
)
}
\arguments{
\item{n}{matrix of observed counts}

\item{rho}{values of row locations. Default is 1:nrow(n) - (nrow(n) + 1) / 2}

\item{sigma}{values of column locations. Default is 1:ncol(n) - (ncol(n) + 1) / 2}

\item{update_rows}{should values of row locations be updated? Default is TRUE, update}

\item{update_columns}{should value of column locations be updated? Default is TRUE, update}

\item{max_iter}{maximum number of iterations to perform. Default is 10}

\item{verbose}{should cycle-by-cycle output be produced? Default is FALSE}

\item{exclude_diagonal}{logical. Should the diagonal be excluded
from the computation. Default is FALSE.}
}
\value{
a list containing
   alpha: row effects
   beta: column effects
   rho: centered row locations
   mu: row locations
   sigma: centered column locations
   nu: column locations
   log_likelihood: log(likelihood)
   g_squared: G^2 fit measure
   chisq: X^2 fit measure
   df: degrees of freedom
}
\description{
Fits Goodman's (1979) Model II
}
