# note that several of the estimates below differ from the values found in Cliff (1993, 1996)
# I believe this is due to precision in intermediate results.
test_that("Cliff_dependent_from_matrix", {
  result <- Cliff_dependent_compute_from_matrix(interference_control_1)
  expect_true(abs(0.750 - result$dw) <= 0.0005)
  expect_true(abs(0.143 - result$sigma_dw) <= 0.0005)
  expect_true(abs(5.25 - result$z_dw) <= 0.005)
  expect_true(abs(0.418 - result$db) <= 0.0005)
  expect_true(abs(0.116 - result$sigma_db) <= 0.0005)
  expect_true(abs(3.61 - result$z_db) <= 0.005)
  expect_true(abs(1.168 - result$db_dw) <= 0.0005)
  expect_true(abs(0.227 - result$sigma_db_dw) <= 0.0005,
              info=paste("sigma_db_dw", 0.227, result$sigma_db_dw, abs(0.227 - result$sigma_db_db)))
  expect_true(abs(5.15 - result$z_db_dw) <= 0.005,
              info=paste(5.15, result$z_db_dw, abs(5.15 - result$z_db_dw)))
  expect_true(abs(0.009 - result$cov_db_dw) <= 0.0005,
              info=paste(0.009, result$cov_db_dw))

  result <- Cliff_dependent_compute_from_matrix(interference_control_2)
  expect_true(abs(1.000 - result$dw) <= 0.0005)
  expect_true(abs(0.000 - result$sigma_dw) <= 0.0005)
  expect_true(is.infinite(result$z_dw))
  expect_true(abs(0.555 - result$db) <= 0.0005)
  expect_true(abs(0.112 - result$sigma_db) <= 0.0005)
  expect_true(abs(4.95 - result$z_db) <= 0.005)
  expect_true(abs(1.555- result$db_dw) <= 0.0005)
  expect_true(abs(0.112 - result$sigma_db_dw) <= 0.0005,
              info=paste(0.112, result$sigma_db_dw))
  expect_true(abs(13.88 - result$z_db_dw) <= 0.005,
              info=paste(13.88, result$z_db_dw))
  expect_true(abs(0.000 - result$cov_db_dw) <= 0.0005,
              info=paste(0.000, result$cov_db_dw))

  result <- Cliff_dependent_compute_from_matrix(interference_12)
  expect_true(abs(0.450 - result$dw) <= 0.0005)
  expect_true(abs(0.198 - result$sigma_dw) <= 0.0005)
  expect_true(abs(2.27 - result$z_dw) <= 0.005)
  expect_true(abs(0.263 - result$db) <= 0.0005)
  expect_true(abs(0.112 - result$sigma_db) <= 0.0005)
  expect_true(abs(2.35 - result$z_db) <= 0.005)
  expect_true(abs(0.713 - result$db_dw) <= 0.0005)
  expect_true(abs(0.287 - result$sigma_db_dw) <= 0.0005,
              info=paste(0.287, result$sigma_db_dw))
  expect_true(abs(2.48 - result$z_db_dw) <= 0.005,
              info=paste(2.48, result$z_db_dw))
  expect_true(abs(0.015 - result$cov_db_dw) <= 0.0005,
              info=paste(0.015, result$cov_db_dw))
}
)


test_that("Cliff_dependent_covariance",  {
  mij <- matrix(c(5, 4, 7,
                  9, 3, 2,
                  6, 5, 11), nrow = 3, byrow=TRUE)
  n <- sum(mij)
  scores <- 1:3
  d <- Cliff_as_d_matrix(scores, mij)

  x <- vector("double", length(mij))
  y <- vector("double", length(mij))
  w <- vector("double", length(mij))
  index <- 1
  for (r in 1:nrow(mij)) {
    for (c in 1:ncol(mij)) {
      x[index] <- r
      y[index] <- c
      w[index] <- mij[r, c]
      index <- index + 1
    }
  }
  wd <- Cliff_weighted_d_matrix(x, y, w, w)
  cov1 <- Cliff_dependent_compute_cov(wd)
  cov <- Cliff_dependent_compute_cov_from_d(d)
  expect_equal(cov, cov1)
}
)


Cliff_compare_lists <- function(list1, list2) {
  epsilon <- 5.0e-3

  expect_true(abs(list1$dw - list2$dw) <= epsilon,
              info=paste("dw", list1$dw, list2$dw))
  expect_true(abs(list1$sigma_dw - list2$sigma_dw) <= epsilon,
              info=paste("sigma_dw", list1$sigma_dw, list2$sigma_dw))
  expect_true(abs(list1$z_dw - list2$z_dw) <= epsilon,
              info=paste("z_dw", list1$z_dw, list2$z_dw))

  expect_true(abs(list1$db - list2$db) <= epsilon,
              info=paste("db", list1$db, list2$db, abs(list1$db - list2$db)))
  expect_true(abs(list1$sigma_db - list2$sigma_db) <= epsilon,
              info=paste("sigma_db", list1$sigma_db, list2$sigma_db))
  expect_true(abs(list1$z_db - list2$z_db) <= epsilon,
              info=paste("z_db", list1$z_db, list2$z_db))

  expect_true(abs(list1$db_dw - list2$db_dw) <= epsilon,
              info=paste("db_dw", list1$db_dw, list2$db_dw))
  expect_true(abs(list1$sigma_db_dw - list2$sigma_db_dw) <= epsilon,
              info=paste("sigma_db_dw", list1$sigma_db_dw, list2$z_db_dw))
  expect_true(abs(list1$z_db_dw - list2$z_db_dw) <= epsilon,
              info=paste("z_db_dw", list1$z_db_dw, list2$z_db_dw))

  expect_true(abs(list1$cov_db_dw - list2$cov_db_dw) <= epsilon,
              info=paste("cov_db_dw", list1$cov_db_dw, list2$cov_db_dw))
}


# test function to verify results match Cliff (1993).
test_that("Cliff_dependent_basic", {
  w <- c(5, 9, 7, 3, 12, 4)
  x <- c(5, 2, 4, 7, 9, 8)
  y <- c(7, 3, 1, 7, 8, 3)
  x1 <- expand(x, w)
  y1 <- expand(y, w)
  d <- Cliff_compute_d(x1, y1)

  r1 <- Cliff_dependent_compute_from_matrix(d)
  r2 <- Cliff_dependent(d)
  Cliff_compare_lists(r1, r2)
}
)

test_that("Cliff_dependent_movies", {
  testthat::skip_on_cran()
  n <- movies
  # print("running movies - vision_data takes too long to run on cran for the unweighted comparison")
  result1 <- Cliff_dependent_compute_paired_d(n)
  result2 <- Cliff_dependent_compute_from_table(n)
  Cliff_compare_lists(result1, result2)
}
)
