% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\name{qswur_usa}
\alias{qswur_usa}
\title{U.S. university rankings}
\format{
A \link[tibble:tibble]{tibble} of 13 variables on 612 cases:
\describe{
\item{\code{year}}{year of rankings}
\item{\code{institution}}{institution of higher learning}
\item{\code{size}}{size category of institution}
\item{\code{focus}}{subject range of institution}
\item{\code{res}}{research intensity of institution}
\item{\code{age}}{age classification of institution}
\item{\code{status}}{status of institution}
\item{\code{rk_academic}}{rank by academic reputation}
\item{\code{rk_employer}}{rank by employer reputation}
\item{\code{rk_ratio}}{rank by faculty--student ratio}
\item{\code{rk_citations}}{rank by citations per faculty}
\item{\code{rk_intl_faculty}}{rank by international faculty ratio}
\item{\code{rk_intl_students}}{rank by international student ratio}
}
}
\source{
Quacquarelli Symonds (2021).
}
\usage{
data(qswur_usa)
}
\description{
Classifications and rankings of U.S. universities for the years
2017--2020.
}
\details{
Ranking data were obtained from the public QS website.
}
\examples{
# subset QS data to rank variables
head(qswur_usa)
qs_ranks <- subset(
  qswur_usa,
  complete.cases(qswur_usa),
  select = 8:13
)
# calculate Kendall correlation matrix
qs_cor <- cor(qs_ranks, method = "kendall")

# calculate eigendecomposition
qs_eigen <- eigen_ord(qs_cor)
# view correlations as cosines of biplot vectors
biplot(x = qs_eigen$vectors, y = qs_eigen$vectors, col = c(NA, "black"))
}
\references{
Quacquarelli Symonds (2021) "University Rankings". TopUniversities.com
\url{https://www.topuniversities.com/university-rankings}.
}
\keyword{datasets}
