% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\docType{methods}
\name{as-methods}
\alias{as-methods}
\alias{as.data.frame}
\alias{as.matrix}
\alias{as.loca.p,data.frame-method}
\alias{as.loca.p,matrix-method}
\title{as-methods}
\arguments{
\item{x}{is the object to convert to the new class object.}

\item{row.names}{Unused.}

\item{optional}{Unused.}

\item{...}{Other arguments, unused.}
}
\value{
It returns a new object of the new class.
}
\description{
Conversions between loca.p class and some others classes
}
\details{
Methods to convert from and to \code{loca.p} class.


NA's  values are not allowed in any of the arguments.

The \code{matrix} or \code{data.frame} to convert into \code{loca.p} must have at least two columns.
The first column will be consider as the x coordinates, the second as the y coordinates, and the third (if given) as the values of weights \code{w}.
}
\examples{
# A new unweighted loca.p object
loca <- loca.p(x = c(-1, 1, 1, -1), y = c(-1, -1, 1, 1))

# Conversion to matrix
m <- as.matrix(loca)

# Show matrix
m

# Conversion from matrix
as.loca.p(m)
}
\seealso{
See also \code{\link{loca.p}}
}
\keyword{classes}
\keyword{methods}
