% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloads_api.R
\name{list_os_opendata}
\alias{list_os_opendata}
\title{Retrieve information on OS OpenData Downloads}
\usage{
list_os_opendata(product_id, file_name, file_format, file_subformat, area, ...)
}
\arguments{
\item{product_id}{(character) Retrieve information on a specific data
product. Optional.}

\item{file_name}{(character) Filter downloads to only include those with this
file name. Optional.}

\item{file_format}{(character) Filter downloads to only include those with
this format. Optional.}

\item{file_subformat}{(character) Filter downloads to only include those with
this subformat. Optional.}

\item{area}{(character) Filter downloads for only this area. Use 'GB' for all
Great Britain. Optional.}

\item{...}{Additional paramters. Not currently used.}
}
\value{
A \code{data.frame} or a \code{product_list}, which extends a
\code{data.frame}, containing the information on downloadable files from
the Downloads API.
}
\description{
Query the osdatahub Downloads API to gather information on available data
collections. An API key is not required to list OS OpenData.
}
\details{
The OS Downloads API assists with the discovery and download of OS
OpenData and OS premium data packages. This function is used for initial
listing and discovery of open data products. Use the product ID from this
list to filter further or to initiate a download.

When a \code{product_id} is not specified then all available open data is
listed. Additional filters (i.e. \code{file_name}, \code{file_format},
\code{file_subformat}, \code{area}) can be used to find the specific
download, but these filters are only valid when a specific product has been
specified first.

The optional \code{area} filter is based on two-letter British National
Grid tiles. Use 'GB' for all of Great Britain. Valid values area: GB, HP,
HT, HU, HW, HX, HY, HZ, NA, NB, NC, ND, NF, NG, NH, NJ, NK, NL, NM, NN, NO,
NR, NS, NT, NU, NW, NX, NY, NZ, OV, SD, SE, TA, SH, SJ, SK, TF, TG, SM, SN,
SO, SP, TL, TM, SR, SS, ST, SU, TQ, TR, SV, SW, SX, SY, SZ, TV.

For more information on the Downloads API, see
\url{https://osdatahub.os.uk/docs/downloads/technicalSpecification}.
}
\examples{
\donttest{
# Retrieve a data.frame listing all OS OpenData products.
opendata <- list_os_opendata()
opendata[, c("name", "url")]
}

}
\seealso{
\code{\link[=download_os_opendata]{download_os_opendata()}}
}
