% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osf_mkdir.R
\name{osf_mkdir}
\alias{osf_mkdir}
\title{Create directories on OSF}
\usage{
osf_mkdir(x, path, verbose = FALSE)
}
\arguments{
\item{x}{One of the following:
\itemize{
\item An \code{\link{osf_tbl_node}} with a single OSF project or component.
\item An \code{\link{osf_tbl_file}} containing a single directory.
}}

\item{path}{Name of the new directory or a path ending with the new directory.}

\item{verbose}{Logical, indicating whether to print informative messages
about interactions with the OSF API (default \code{FALSE}).}
}
\value{
An \code{\link{osf_tbl_file}} with one row containing the leaf directory
specified in \code{path}.
}
\description{
Use \code{osf_mkdir()} to add new directories to projects, components, or nested
within existing OSF directories. If \code{path} contains multiple directory
levels (e.g., \code{"data/rawdata"}) the intermediate-level directories are
created automatically. If the directory you're attempting to create already
exists on OSF it will be silently ignored and included in the output.
}
\examples{
\dontrun{
proj <- osf_create_project("Directory Example")

# add directory to the top-level of the Directory Example project
data_dir <- osf_mkdir(proj, path = "data")

# add a subdirectory nested within data/
osf_mkdir(data_dir, path = "rawdata")

# recursively create multiple directory levels within data/
osf_mkdir(data_dir, path = "samples/pcr/qc")
}
}
\seealso{
Other OSF file operations: 
\code{\link{osf_cp}()},
\code{\link{osf_mv}()},
\code{\link{osf_rm}()}
}
\concept{OSF file operations}
