% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtw.R
\name{data_transform}
\alias{data_transform}
\title{Pseudotime based Expression Data Transformation}
\usage{
data_transform(data, pseudotime, slide_window_size = 100, slide_step_size = 50)
}
\arguments{
\item{data}{expression matrix data}

\item{pseudotime}{list of pseudotime}

\item{slide_window_size}{sliding window size}

\item{slide_step_size}{sliding window step size}
}
\value{
Transformed new matrix
}
\description{
Based on single-cell pseudotime information, get the sliding window average expression,
and then standard normlize the expression for each gene
}
\examples{
data <- matrix(1,100,1000)
ptime <- seq(1:1000)
data_transform(data,
               ptime,
               slide_window_size=100,
               slide_step_size=50)

}
