% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{plot_network_i}
\alias{plot_network_i}
\title{Plot interactive network}
\usage{
plot_network_i(graph, save_file = NULL)
}
\arguments{
\item{graph}{igraph layout object}

\item{save_file}{file name of the saved file, not save if NULL}
}
\value{
visNetwork htmlwidget
}
\description{
Plot interactive network based on igraph layout input
}
\examples{
example_data <- pGRNDB
expression_matrix <- example_data[["expression"]]
pseudotime_list <- example_data[["ptime"]]$PseudoTime
dtw_dist_matrix <- get_dtw_dist_mat(expression_matrix,
                                    pseudotime_list,
                                    cores=1)
nets <- module_networks(dtw_dist_matrix,k=1,quantile_cutoff=50)
plot_network_i(nets[["module1"]])
}
