% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discounts.R
\name{paddle_create_discount}
\alias{paddle_create_discount}
\title{Create a Paddle Discount}
\usage{
paddle_create_discount(
  amount,
  description,
  type,
  enabled_for_checkout = NULL,
  code = NULL,
  mode = NULL,
  currency_code = NULL,
  recur = NULL,
  maximum_recurring_intervals = NULL,
  usage_limit = NULL,
  restrict_to = NULL,
  expires_at = NULL,
  custom_data = NULL
)
}
\arguments{
\item{amount}{Character. Amount to discount by. Required.}

\item{description}{Character. Internal description of the discount. Required.}

\item{type}{Character. Type of discount (`"percentage"`, `"flat"`, or `"flat_per_seat"`). Required.}

\item{enabled_for_checkout}{Logical. Can be used at checkout? Optional.}

\item{code}{Character. Optional promo code (letters/numbers, max 32 characters).}

\item{mode}{Character. Filter discounts by mode (one of `"standard"`, `"custom"`). Optional.}

\item{currency_code}{Character. Required for `"flat"` or `"flat_per_seat"`. Optional.}

\item{recur}{Logical. Should it recur for subscriptions? Optional.}

\item{maximum_recurring_intervals}{Integer. Number of times to recur. Optional.}

\item{usage_limit}{Integer. Maximum redemptions. Optional.}

\item{restrict_to}{Character vector of product or price IDs. Optional.}

\item{expires_at}{Character. RFC 3339 datetime string. Optional.}

\item{custom_data}{Named list. Custom metadata. Optional.}
}
\value{
A list containing the created discount and metadata.
}
\description{
Sends a POST request to the Paddle API to create a new discount.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_create_discount(
 amount = "10.00",
 description = "10\% off",
 type = "percentage")
\dontshow{\}) # examplesIf}
}
