% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prices.R
\name{paddle_update_price}
\alias{paddle_update_price}
\title{Update a Paddle Price}
\usage{
paddle_update_price(
  id,
  description = NULL,
  type = NULL,
  name = NULL,
  billing_cycle = NULL,
  trial_period = NULL,
  tax_mode = NULL,
  unit_price = NULL,
  unit_price_overrides = NULL,
  quantity = NULL,
  status = NULL,
  custom_data = NULL
)
}
\arguments{
\item{id}{ID of the price. Required.}

\item{description}{Internal description for your team. Required.}

\item{type}{Type of item (one of `"standard"` and `"custom"`). Optional. Defaults to `"standard"`.}

\item{name}{Name of this price (shown at checkout/invoices). Optional.}

\item{billing_cycle}{List with `frequency` and `interval` (one of `"day"`, `"week"`, `"month"`, `"year"`). Optional. Omit for one-time pricing.}

\item{trial_period}{List with `frequency` and `interval` (one of `"day"`, `"week"`, `"month"`, `"year"`). Optional. Requires `billing_cycle`.}

\item{tax_mode}{One of `"account_setting"`, `"external"`, `"internal"`. Optional.}

\item{unit_price}{A list with `amount` (string, lowest denomination, e.g. for 10 USD write 1000 (lowest denomination = cents)) and `currency_code` (3-letter ISO). Required.}

\item{unit_price_overrides}{A list of overrides with `country_codes` (Supported two-letter ISO 3166-1 alpha-2 country code) and `unit_price` (same list as in unit_price parameter). Optional.}

\item{quantity}{List with `minimum` and `maximum` quantity limits. Optional.}

\item{status}{Status of the price (one of `"active"`, `"archived"`). Optional.}

\item{custom_data}{Named list of custom metadata. Optional.}
}
\value{
A list representing the updated price entity.
}
\description{
Updates an existing price entity in Paddle using its ID.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_update_price(
  id = "pri_123",
  name = "Updated Price Name"
)
\dontshow{\}) # examplesIf}
}
