% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transactions.R
\name{paddle_update_transaction}
\alias{paddle_update_transaction}
\title{Update a Transaction}
\usage{
paddle_update_transaction(
  id,
  status = NULL,
  customer_id = NULL,
  address_id = NULL,
  business_id = NULL,
  custom_data = NULL,
  currency_code = NULL,
  collection_mode = NULL,
  discount_id = NULL,
  billing_details = NULL,
  payment_terms = NULL,
  billing_period = NULL,
  items = NULL,
  checkout_url = NULL,
  include = NULL
)
}
\arguments{
\item{id}{Character. Required. Paddle ID of the transaction (e.g. `"txn_abc123"`).}

\item{status}{Character. Optional. `"billed"` or `"canceled"`.}

\item{customer_id, address_id, business_id}{Character. Optional Paddle IDs.}

\item{custom_data}{Named list. Optional.}

\item{currency_code}{Character. Optional. `"USD"`, `"EUR"`, or `"GBP"` if `collection_mode = "manual"`.}

\item{collection_mode}{Character. Optional. `"automatic"` or `"manual"`.}

\item{discount_id}{Character. Optional.}

\item{billing_details}{List. Optional, see API.}

\item{payment_terms}{List with `interval` and `frequency`. Shortcut to fill `billing_details$payment_terms`.}

\item{billing_period}{List with `starts_at` and `ends_at` in RFC 3339 format. Optional.}

\item{items}{List of objects with `price_id` and `quantity`. Optional.}

\item{checkout_url}{Character. Optional.}

\item{include}{Character vector of related entities to return. Optional.}
}
\value{
A list with updated transaction data and metadata.
}
\description{
Updates a transaction by its ID. Only transactions with status `draft` or `ready` can be updated.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_create_transaction(
 items = list(
 list(price_id = "price_123", quantity = 1)
 )
)
\dontshow{\}) # examplesIf}
}
